package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.EmailTemplateName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteEmailTemplateRequest(templateName: EmailTemplateName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.DeleteEmailTemplateRequest = {
    import DeleteEmailTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.DeleteEmailTemplateRequest
      .builder()
      .templateName(EmailTemplateName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.DeleteEmailTemplateRequest.ReadOnly =
    zio.aws.sesv2.model.DeleteEmailTemplateRequest.wrap(buildAwsValue())
}
object DeleteEmailTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.DeleteEmailTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.DeleteEmailTemplateRequest =
      zio.aws.sesv2.model.DeleteEmailTemplateRequest(templateName)
    def templateName: EmailTemplateName
    def getTemplateName: ZIO[Any, Nothing, EmailTemplateName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.DeleteEmailTemplateRequest
  ) extends zio.aws.sesv2.model.DeleteEmailTemplateRequest.ReadOnly {
    override val templateName: EmailTemplateName =
      zio.aws.sesv2.model.primitives.EmailTemplateName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.DeleteEmailTemplateRequest
  ): zio.aws.sesv2.model.DeleteEmailTemplateRequest.ReadOnly = new Wrapper(impl)
}
