package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.CaseId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ReviewDetails(
    status: Option[zio.aws.sesv2.model.ReviewStatus] = None,
    caseId: Option[CaseId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ReviewDetails = {
    import ReviewDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ReviewDetails
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        caseId.map(value => CaseId.unwrap(value): java.lang.String)
      )(_.caseId)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ReviewDetails.ReadOnly =
    zio.aws.sesv2.model.ReviewDetails.wrap(buildAwsValue())
}
object ReviewDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ReviewDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ReviewDetails = zio.aws.sesv2.model
      .ReviewDetails(status.map(value => value), caseId.map(value => value))
    def status: Option[zio.aws.sesv2.model.ReviewStatus]
    def caseId: Option[CaseId]
    def getStatus: ZIO[Any, AwsError, zio.aws.sesv2.model.ReviewStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCaseId: ZIO[Any, AwsError, CaseId] =
      AwsError.unwrapOptionField("caseId", caseId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ReviewDetails
  ) extends zio.aws.sesv2.model.ReviewDetails.ReadOnly {
    override val status: Option[zio.aws.sesv2.model.ReviewStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.sesv2.model.ReviewStatus.wrap(value))
    override val caseId: Option[CaseId] = scala
      .Option(impl.caseId())
      .map(value => zio.aws.sesv2.model.primitives.CaseId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ReviewDetails
  ): zio.aws.sesv2.model.ReviewDetails.ReadOnly = new Wrapper(impl)
}
