package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{LastFreshStart, Enabled}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ReputationOptions(
    reputationMetricsEnabled: Option[Enabled] = None,
    lastFreshStart: Option[LastFreshStart] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ReputationOptions = {
    import ReputationOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ReputationOptions
      .builder()
      .optionallyWith(
        reputationMetricsEnabled.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.reputationMetricsEnabled)
      .optionallyWith(
        lastFreshStart.map(value => LastFreshStart.unwrap(value): Instant)
      )(_.lastFreshStart)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ReputationOptions.ReadOnly =
    zio.aws.sesv2.model.ReputationOptions.wrap(buildAwsValue())
}
object ReputationOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ReputationOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ReputationOptions =
      zio.aws.sesv2.model.ReputationOptions(
        reputationMetricsEnabled.map(value => value),
        lastFreshStart.map(value => value)
      )
    def reputationMetricsEnabled: Option[Enabled]
    def lastFreshStart: Option[LastFreshStart]
    def getReputationMetricsEnabled: ZIO[Any, AwsError, Enabled] = AwsError
      .unwrapOptionField("reputationMetricsEnabled", reputationMetricsEnabled)
    def getLastFreshStart: ZIO[Any, AwsError, LastFreshStart] =
      AwsError.unwrapOptionField("lastFreshStart", lastFreshStart)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ReputationOptions
  ) extends zio.aws.sesv2.model.ReputationOptions.ReadOnly {
    override val reputationMetricsEnabled: Option[Enabled] = scala
      .Option(impl.reputationMetricsEnabled())
      .map(value => zio.aws.sesv2.model.primitives.Enabled(value))
    override val lastFreshStart: Option[LastFreshStart] = scala
      .Option(impl.lastFreshStart())
      .map(value => zio.aws.sesv2.model.primitives.LastFreshStart(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ReputationOptions
  ): zio.aws.sesv2.model.ReputationOptions.ReadOnly = new Wrapper(impl)
}
