package zio.aws.sesv2.model
import java.lang.Integer
import zio.aws.sesv2.model.primitives.{MaxItems, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListEmailTemplatesRequest(
    nextToken: Option[NextToken] = None,
    pageSize: Option[MaxItems] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesRequest = {
    import ListEmailTemplatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(pageSize.map(value => MaxItems.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ListEmailTemplatesRequest.ReadOnly =
    zio.aws.sesv2.model.ListEmailTemplatesRequest.wrap(buildAwsValue())
}
object ListEmailTemplatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ListEmailTemplatesRequest =
      zio.aws.sesv2.model.ListEmailTemplatesRequest(
        nextToken.map(value => value),
        pageSize.map(value => value)
      )
    def nextToken: Option[NextToken]
    def pageSize: Option[MaxItems]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPageSize: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesRequest
  ) extends zio.aws.sesv2.model.ListEmailTemplatesRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
    override val pageSize: Option[MaxItems] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.sesv2.model.primitives.MaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesRequest
  ): zio.aws.sesv2.model.ListEmailTemplatesRequest.ReadOnly = new Wrapper(impl)
}
