package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDeliverabilityTestReportsResponse(
    deliverabilityTestReports: Iterable[
      zio.aws.sesv2.model.DeliverabilityTestReport
    ],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsResponse = {
    import ListDeliverabilityTestReportsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsResponse
      .builder()
      .deliverabilityTestReports(deliverabilityTestReports.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.ListDeliverabilityTestReportsResponse.ReadOnly =
    zio.aws.sesv2.model.ListDeliverabilityTestReportsResponse
      .wrap(buildAwsValue())
}
object ListDeliverabilityTestReportsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ListDeliverabilityTestReportsResponse =
      zio.aws.sesv2.model.ListDeliverabilityTestReportsResponse(
        deliverabilityTestReports.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def deliverabilityTestReports
        : List[zio.aws.sesv2.model.DeliverabilityTestReport.ReadOnly]
    def nextToken: Option[NextToken]
    def getDeliverabilityTestReports: ZIO[Any, Nothing, List[
      zio.aws.sesv2.model.DeliverabilityTestReport.ReadOnly
    ]] = ZIO.succeed(deliverabilityTestReports)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsResponse
  ) extends zio.aws.sesv2.model.ListDeliverabilityTestReportsResponse.ReadOnly {
    override val deliverabilityTestReports
        : List[zio.aws.sesv2.model.DeliverabilityTestReport.ReadOnly] = impl
      .deliverabilityTestReports()
      .asScala
      .map { item =>
        zio.aws.sesv2.model.DeliverabilityTestReport.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsResponse
  ): zio.aws.sesv2.model.ListDeliverabilityTestReportsResponse.ReadOnly =
    new Wrapper(impl)
}
