package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListCustomVerificationEmailTemplatesResponse(
    customVerificationEmailTemplates: Option[
      Iterable[zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesResponse = {
    import ListCustomVerificationEmailTemplatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesResponse
      .builder()
      .optionallyWith(
        customVerificationEmailTemplates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customVerificationEmailTemplates)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesResponse.ReadOnly =
    zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesResponse
      .wrap(buildAwsValue())
}
object ListCustomVerificationEmailTemplatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesResponse =
      zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesResponse(
        customVerificationEmailTemplates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def customVerificationEmailTemplates: Option[
      List[zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getCustomVerificationEmailTemplates: ZIO[Any, AwsError, List[
      zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "customVerificationEmailTemplates",
      customVerificationEmailTemplates
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesResponse
  ) extends zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesResponse.ReadOnly {
    override val customVerificationEmailTemplates: Option[
      List[zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata.ReadOnly]
    ] = scala
      .Option(impl.customVerificationEmailTemplates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesResponse
  ): zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesResponse.ReadOnly =
    new Wrapper(impl)
}
