package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListContactsResponse(
    contacts: Option[Iterable[zio.aws.sesv2.model.Contact]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListContactsResponse = {
    import ListContactsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListContactsResponse
      .builder()
      .optionallyWith(
        contacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contacts)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ListContactsResponse.ReadOnly =
    zio.aws.sesv2.model.ListContactsResponse.wrap(buildAwsValue())
}
object ListContactsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListContactsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ListContactsResponse =
      zio.aws.sesv2.model.ListContactsResponse(
        contacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def contacts: Option[List[zio.aws.sesv2.model.Contact.ReadOnly]]
    def nextToken: Option[NextToken]
    def getContacts
        : ZIO[Any, AwsError, List[zio.aws.sesv2.model.Contact.ReadOnly]] =
      AwsError.unwrapOptionField("contacts", contacts)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListContactsResponse
  ) extends zio.aws.sesv2.model.ListContactsResponse.ReadOnly {
    override val contacts: Option[List[zio.aws.sesv2.model.Contact.ReadOnly]] =
      scala
        .Option(impl.contacts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.Contact.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListContactsResponse
  ): zio.aws.sesv2.model.ListContactsResponse.ReadOnly = new Wrapper(impl)
}
