package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListContactsFilter(
    filteredStatus: Option[zio.aws.sesv2.model.SubscriptionStatus] = None,
    topicFilter: Option[zio.aws.sesv2.model.TopicFilter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListContactsFilter = {
    import ListContactsFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListContactsFilter
      .builder()
      .optionallyWith(filteredStatus.map(value => value.unwrap))(
        _.filteredStatus
      )
      .optionallyWith(topicFilter.map(value => value.buildAwsValue()))(
        _.topicFilter
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ListContactsFilter.ReadOnly =
    zio.aws.sesv2.model.ListContactsFilter.wrap(buildAwsValue())
}
object ListContactsFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListContactsFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ListContactsFilter =
      zio.aws.sesv2.model.ListContactsFilter(
        filteredStatus.map(value => value),
        topicFilter.map(value => value.asEditable)
      )
    def filteredStatus: Option[zio.aws.sesv2.model.SubscriptionStatus]
    def topicFilter: Option[zio.aws.sesv2.model.TopicFilter.ReadOnly]
    def getFilteredStatus
        : ZIO[Any, AwsError, zio.aws.sesv2.model.SubscriptionStatus] =
      AwsError.unwrapOptionField("filteredStatus", filteredStatus)
    def getTopicFilter
        : ZIO[Any, AwsError, zio.aws.sesv2.model.TopicFilter.ReadOnly] =
      AwsError.unwrapOptionField("topicFilter", topicFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListContactsFilter
  ) extends zio.aws.sesv2.model.ListContactsFilter.ReadOnly {
    override val filteredStatus
        : Option[zio.aws.sesv2.model.SubscriptionStatus] = scala
      .Option(impl.filteredStatus())
      .map(value => zio.aws.sesv2.model.SubscriptionStatus.wrap(value))
    override val topicFilter: Option[zio.aws.sesv2.model.TopicFilter.ReadOnly] =
      scala
        .Option(impl.topicFilter())
        .map(value => zio.aws.sesv2.model.TopicFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListContactsFilter
  ): zio.aws.sesv2.model.ListContactsFilter.ReadOnly = new Wrapper(impl)
}
