package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.S3Url
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ImportDataSource(
    s3Url: S3Url,
    dataFormat: zio.aws.sesv2.model.DataFormat
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ImportDataSource = {
    import ImportDataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ImportDataSource
      .builder()
      .s3Url(S3Url.unwrap(s3Url): java.lang.String)
      .dataFormat(dataFormat.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ImportDataSource.ReadOnly =
    zio.aws.sesv2.model.ImportDataSource.wrap(buildAwsValue())
}
object ImportDataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ImportDataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ImportDataSource =
      zio.aws.sesv2.model.ImportDataSource(s3Url, dataFormat)
    def s3Url: S3Url
    def dataFormat: zio.aws.sesv2.model.DataFormat
    def getS3Url: ZIO[Any, Nothing, S3Url] = ZIO.succeed(s3Url)
    def getDataFormat: ZIO[Any, Nothing, zio.aws.sesv2.model.DataFormat] =
      ZIO.succeed(dataFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ImportDataSource
  ) extends zio.aws.sesv2.model.ImportDataSource.ReadOnly {
    override val s3Url: S3Url =
      zio.aws.sesv2.model.primitives.S3Url(impl.s3Url())
    override val dataFormat: zio.aws.sesv2.model.DataFormat =
      zio.aws.sesv2.model.DataFormat.wrap(impl.dataFormat())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ImportDataSource
  ): zio.aws.sesv2.model.ImportDataSource.ReadOnly = new Wrapper(impl)
}
