package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{Charset, MessageData}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Content(data: MessageData, charset: Option[Charset] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.sesv2.model.Content = {
    import Content.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.Content
      .builder()
      .data(MessageData.unwrap(data): java.lang.String)
      .optionallyWith(
        charset.map(value => Charset.unwrap(value): java.lang.String)
      )(_.charset)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.Content.ReadOnly =
    zio.aws.sesv2.model.Content.wrap(buildAwsValue())
}
object Content {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sesv2.model.Content] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.Content =
      zio.aws.sesv2.model.Content(data, charset.map(value => value))
    def data: MessageData
    def charset: Option[Charset]
    def getData: ZIO[Any, Nothing, MessageData] = ZIO.succeed(data)
    def getCharset: ZIO[Any, AwsError, Charset] =
      AwsError.unwrapOptionField("charset", charset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.Content
  ) extends zio.aws.sesv2.model.Content.ReadOnly {
    override val data: MessageData =
      zio.aws.sesv2.model.primitives.MessageData(impl.data())
    override val charset: Option[Charset] = scala
      .Option(impl.charset())
      .map(value => zio.aws.sesv2.model.primitives.Charset(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.Content
  ): zio.aws.sesv2.model.Content.ReadOnly = new Wrapper(impl)
}
