package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListImportJobsResponse(
    importJobs: Option[Iterable[zio.aws.sesv2.model.ImportJobSummary]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListImportJobsResponse = {
    import ListImportJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListImportJobsResponse
      .builder()
      .optionallyWith(
        importJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.importJobs)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ListImportJobsResponse.ReadOnly =
    zio.aws.sesv2.model.ListImportJobsResponse.wrap(buildAwsValue())
}
object ListImportJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListImportJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ListImportJobsResponse =
      zio.aws.sesv2.model.ListImportJobsResponse(
        importJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def importJobs: Option[List[zio.aws.sesv2.model.ImportJobSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getImportJobs: ZIO[Any, AwsError, List[
      zio.aws.sesv2.model.ImportJobSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("importJobs", importJobs)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListImportJobsResponse
  ) extends zio.aws.sesv2.model.ListImportJobsResponse.ReadOnly {
    override val importJobs
        : Option[List[zio.aws.sesv2.model.ImportJobSummary.ReadOnly]] = scala
      .Option(impl.importJobs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.ImportJobSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListImportJobsResponse
  ): zio.aws.sesv2.model.ListImportJobsResponse.ReadOnly = new Wrapper(impl)
}
