package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListContactListsResponse(
    contactLists: Option[Iterable[zio.aws.sesv2.model.ContactList]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListContactListsResponse = {
    import ListContactListsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListContactListsResponse
      .builder()
      .optionallyWith(
        contactLists.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contactLists)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ListContactListsResponse.ReadOnly =
    zio.aws.sesv2.model.ListContactListsResponse.wrap(buildAwsValue())
}
object ListContactListsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListContactListsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ListContactListsResponse =
      zio.aws.sesv2.model.ListContactListsResponse(
        contactLists.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def contactLists: Option[List[zio.aws.sesv2.model.ContactList.ReadOnly]]
    def nextToken: Option[NextToken]
    def getContactLists
        : ZIO[Any, AwsError, List[zio.aws.sesv2.model.ContactList.ReadOnly]] =
      AwsError.unwrapOptionField("contactLists", contactLists)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListContactListsResponse
  ) extends zio.aws.sesv2.model.ListContactListsResponse.ReadOnly {
    override val contactLists
        : Option[List[zio.aws.sesv2.model.ContactList.ReadOnly]] = scala
      .Option(impl.contactLists())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.ContactList.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListContactListsResponse
  ): zio.aws.sesv2.model.ListContactListsResponse.ReadOnly = new Wrapper(impl)
}
