package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetConfigurationSetEventDestinationsResponse(
    eventDestinations: Option[Iterable[zio.aws.sesv2.model.EventDestination]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetConfigurationSetEventDestinationsResponse = {
    import GetConfigurationSetEventDestinationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetConfigurationSetEventDestinationsResponse
      .builder()
      .optionallyWith(
        eventDestinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventDestinations)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.GetConfigurationSetEventDestinationsResponse.ReadOnly =
    zio.aws.sesv2.model.GetConfigurationSetEventDestinationsResponse
      .wrap(buildAwsValue())
}
object GetConfigurationSetEventDestinationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetConfigurationSetEventDestinationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.GetConfigurationSetEventDestinationsResponse =
      zio.aws.sesv2.model.GetConfigurationSetEventDestinationsResponse(
        eventDestinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def eventDestinations
        : Option[List[zio.aws.sesv2.model.EventDestination.ReadOnly]]
    def getEventDestinations: ZIO[Any, AwsError, List[
      zio.aws.sesv2.model.EventDestination.ReadOnly
    ]] = AwsError.unwrapOptionField("eventDestinations", eventDestinations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetConfigurationSetEventDestinationsResponse
  ) extends zio.aws.sesv2.model.GetConfigurationSetEventDestinationsResponse.ReadOnly {
    override val eventDestinations
        : Option[List[zio.aws.sesv2.model.EventDestination.ReadOnly]] = scala
      .Option(impl.eventDestinations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.EventDestination.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetConfigurationSetEventDestinationsResponse
  ): zio.aws.sesv2.model.GetConfigurationSetEventDestinationsResponse.ReadOnly =
    new Wrapper(impl)
}
