package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{Timestamp, EmailTemplateName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class EmailTemplateMetadata(
    templateName: Option[EmailTemplateName] = None,
    createdTimestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.EmailTemplateMetadata = {
    import EmailTemplateMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.EmailTemplateMetadata
      .builder()
      .optionallyWith(
        templateName.map(value =>
          EmailTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.EmailTemplateMetadata.ReadOnly =
    zio.aws.sesv2.model.EmailTemplateMetadata.wrap(buildAwsValue())
}
object EmailTemplateMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.EmailTemplateMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.EmailTemplateMetadata =
      zio.aws.sesv2.model.EmailTemplateMetadata(
        templateName.map(value => value),
        createdTimestamp.map(value => value)
      )
    def templateName: Option[EmailTemplateName]
    def createdTimestamp: Option[Timestamp]
    def getTemplateName: ZIO[Any, AwsError, EmailTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.EmailTemplateMetadata
  ) extends zio.aws.sesv2.model.EmailTemplateMetadata.ReadOnly {
    override val templateName: Option[EmailTemplateName] = scala
      .Option(impl.templateName())
      .map(value => zio.aws.sesv2.model.primitives.EmailTemplateName(value))
    override val createdTimestamp: Option[Timestamp] = scala
      .Option(impl.createdTimestamp())
      .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.EmailTemplateMetadata
  ): zio.aws.sesv2.model.EmailTemplateMetadata.ReadOnly = new Wrapper(impl)
}
