package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.Enabled
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SendingOptions(sendingEnabled: Option[Enabled] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.SendingOptions = {
    import SendingOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.SendingOptions
      .builder()
      .optionallyWith(
        sendingEnabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.sendingEnabled)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.SendingOptions.ReadOnly =
    zio.aws.sesv2.model.SendingOptions.wrap(buildAwsValue())
}
object SendingOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.SendingOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.SendingOptions =
      zio.aws.sesv2.model.SendingOptions(sendingEnabled.map(value => value))
    def sendingEnabled: Option[Enabled]
    def getSendingEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("sendingEnabled", sendingEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.SendingOptions
  ) extends zio.aws.sesv2.model.SendingOptions.ReadOnly {
    override val sendingEnabled: Option[Enabled] = scala
      .Option(impl.sendingEnabled())
      .map(value => zio.aws.sesv2.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.SendingOptions
  ): zio.aws.sesv2.model.SendingOptions.ReadOnly = new Wrapper(impl)
}
