package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.ConfigurationSetName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutConfigurationSetSuppressionOptionsRequest(
    configurationSetName: ConfigurationSetName,
    suppressedReasons: Option[
      Iterable[zio.aws.sesv2.model.SuppressionListReason]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSuppressionOptionsRequest = {
    import PutConfigurationSetSuppressionOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSuppressionOptionsRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .optionallyWith(
        suppressedReasons.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.suppressedReasonsWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.PutConfigurationSetSuppressionOptionsRequest.ReadOnly =
    zio.aws.sesv2.model.PutConfigurationSetSuppressionOptionsRequest
      .wrap(buildAwsValue())
}
object PutConfigurationSetSuppressionOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSuppressionOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.PutConfigurationSetSuppressionOptionsRequest =
      zio.aws.sesv2.model.PutConfigurationSetSuppressionOptionsRequest(
        configurationSetName,
        suppressedReasons.map(value => value)
      )
    def configurationSetName: ConfigurationSetName
    def suppressedReasons
        : Option[List[zio.aws.sesv2.model.SuppressionListReason]]
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getSuppressedReasons
        : ZIO[Any, AwsError, List[zio.aws.sesv2.model.SuppressionListReason]] =
      AwsError.unwrapOptionField("suppressedReasons", suppressedReasons)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSuppressionOptionsRequest
  ) extends zio.aws.sesv2.model.PutConfigurationSetSuppressionOptionsRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.sesv2.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val suppressedReasons
        : Option[List[zio.aws.sesv2.model.SuppressionListReason]] = scala
      .Option(impl.suppressedReasons())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.SuppressionListReason.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSuppressionOptionsRequest
  ): zio.aws.sesv2.model.PutConfigurationSetSuppressionOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
