package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutAccountSuppressionAttributesRequest(
    suppressedReasons: Option[
      Iterable[zio.aws.sesv2.model.SuppressionListReason]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.PutAccountSuppressionAttributesRequest = {
    import PutAccountSuppressionAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.PutAccountSuppressionAttributesRequest
      .builder()
      .optionallyWith(
        suppressedReasons.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.suppressedReasonsWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.PutAccountSuppressionAttributesRequest.ReadOnly =
    zio.aws.sesv2.model.PutAccountSuppressionAttributesRequest
      .wrap(buildAwsValue())
}
object PutAccountSuppressionAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.PutAccountSuppressionAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.PutAccountSuppressionAttributesRequest =
      zio.aws.sesv2.model.PutAccountSuppressionAttributesRequest(
        suppressedReasons.map(value => value)
      )
    def suppressedReasons
        : Option[List[zio.aws.sesv2.model.SuppressionListReason]]
    def getSuppressedReasons
        : ZIO[Any, AwsError, List[zio.aws.sesv2.model.SuppressionListReason]] =
      AwsError.unwrapOptionField("suppressedReasons", suppressedReasons)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.PutAccountSuppressionAttributesRequest
  ) extends zio.aws.sesv2.model.PutAccountSuppressionAttributesRequest.ReadOnly {
    override val suppressedReasons
        : Option[List[zio.aws.sesv2.model.SuppressionListReason]] = scala
      .Option(impl.suppressedReasons())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.SuppressionListReason.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.PutAccountSuppressionAttributesRequest
  ): zio.aws.sesv2.model.PutAccountSuppressionAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
