package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class KinesisFirehoseDestination(
    iamRoleArn: AmazonResourceName,
    deliveryStreamArn: AmazonResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.KinesisFirehoseDestination = {
    import KinesisFirehoseDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.KinesisFirehoseDestination
      .builder()
      .iamRoleArn(AmazonResourceName.unwrap(iamRoleArn): java.lang.String)
      .deliveryStreamArn(
        AmazonResourceName.unwrap(deliveryStreamArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.KinesisFirehoseDestination.ReadOnly =
    zio.aws.sesv2.model.KinesisFirehoseDestination.wrap(buildAwsValue())
}
object KinesisFirehoseDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.KinesisFirehoseDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.KinesisFirehoseDestination =
      zio.aws.sesv2.model
        .KinesisFirehoseDestination(iamRoleArn, deliveryStreamArn)
    def iamRoleArn: AmazonResourceName
    def deliveryStreamArn: AmazonResourceName
    def getIamRoleArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(iamRoleArn)
    def getDeliveryStreamArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(deliveryStreamArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.KinesisFirehoseDestination
  ) extends zio.aws.sesv2.model.KinesisFirehoseDestination.ReadOnly {
    override val iamRoleArn: AmazonResourceName =
      zio.aws.sesv2.model.primitives.AmazonResourceName(impl.iamRoleArn())
    override val deliveryStreamArn: AmazonResourceName =
      zio.aws.sesv2.model.primitives
        .AmazonResourceName(impl.deliveryStreamArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.KinesisFirehoseDestination
  ): zio.aws.sesv2.model.KinesisFirehoseDestination.ReadOnly = new Wrapper(impl)
}
