package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait ContactLanguage {
  def unwrap: software.amazon.awssdk.services.sesv2.model.ContactLanguage
}
object ContactLanguage {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.ContactLanguage
  ): zio.aws.sesv2.model.ContactLanguage = value match {
    case software.amazon.awssdk.services.sesv2.model.ContactLanguage.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.ContactLanguage.EN =>
      val r = EN
      r
    case software.amazon.awssdk.services.sesv2.model.ContactLanguage.JA =>
      val r = JA
      r
  }
  case object unknownToSdkVersion extends zio.aws.sesv2.model.ContactLanguage {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.ContactLanguage =
      software.amazon.awssdk.services.sesv2.model.ContactLanguage.UNKNOWN_TO_SDK_VERSION
  }
  case object EN extends zio.aws.sesv2.model.ContactLanguage {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.ContactLanguage =
      software.amazon.awssdk.services.sesv2.model.ContactLanguage.EN
  }
  case object JA extends zio.aws.sesv2.model.ContactLanguage {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.ContactLanguage =
      software.amazon.awssdk.services.sesv2.model.ContactLanguage.JA
  }
}
