package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{MailFromDomainName, Identity}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutEmailIdentityMailFromAttributesRequest(
    emailIdentity: Identity,
    mailFromDomain: Option[MailFromDomainName] = None,
    behaviorOnMxFailure: Option[zio.aws.sesv2.model.BehaviorOnMxFailure] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.PutEmailIdentityMailFromAttributesRequest = {
    import PutEmailIdentityMailFromAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.PutEmailIdentityMailFromAttributesRequest
      .builder()
      .emailIdentity(Identity.unwrap(emailIdentity): java.lang.String)
      .optionallyWith(
        mailFromDomain.map(value =>
          MailFromDomainName.unwrap(value): java.lang.String
        )
      )(_.mailFromDomain)
      .optionallyWith(behaviorOnMxFailure.map(value => value.unwrap))(
        _.behaviorOnMxFailure
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.PutEmailIdentityMailFromAttributesRequest.ReadOnly =
    zio.aws.sesv2.model.PutEmailIdentityMailFromAttributesRequest
      .wrap(buildAwsValue())
}
object PutEmailIdentityMailFromAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.PutEmailIdentityMailFromAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.PutEmailIdentityMailFromAttributesRequest =
      zio.aws.sesv2.model.PutEmailIdentityMailFromAttributesRequest(
        emailIdentity,
        mailFromDomain.map(value => value),
        behaviorOnMxFailure.map(value => value)
      )
    def emailIdentity: Identity
    def mailFromDomain: Option[MailFromDomainName]
    def behaviorOnMxFailure: Option[zio.aws.sesv2.model.BehaviorOnMxFailure]
    def getEmailIdentity: ZIO[Any, Nothing, Identity] =
      ZIO.succeed(emailIdentity)
    def getMailFromDomain: ZIO[Any, AwsError, MailFromDomainName] =
      AwsError.unwrapOptionField("mailFromDomain", mailFromDomain)
    def getBehaviorOnMxFailure
        : ZIO[Any, AwsError, zio.aws.sesv2.model.BehaviorOnMxFailure] =
      AwsError.unwrapOptionField("behaviorOnMxFailure", behaviorOnMxFailure)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.PutEmailIdentityMailFromAttributesRequest
  ) extends zio.aws.sesv2.model.PutEmailIdentityMailFromAttributesRequest.ReadOnly {
    override val emailIdentity: Identity =
      zio.aws.sesv2.model.primitives.Identity(impl.emailIdentity())
    override val mailFromDomain: Option[MailFromDomainName] = scala
      .Option(impl.mailFromDomain())
      .map(value => zio.aws.sesv2.model.primitives.MailFromDomainName(value))
    override val behaviorOnMxFailure
        : Option[zio.aws.sesv2.model.BehaviorOnMxFailure] = scala
      .Option(impl.behaviorOnMxFailure())
      .map(value => zio.aws.sesv2.model.BehaviorOnMxFailure.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.PutEmailIdentityMailFromAttributesRequest
  ): zio.aws.sesv2.model.PutEmailIdentityMailFromAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
