package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{Timestamp, Identity}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GetDomainStatisticsReportRequest(
    domain: Identity,
    startDate: Timestamp,
    endDate: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetDomainStatisticsReportRequest = {
    import GetDomainStatisticsReportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetDomainStatisticsReportRequest
      .builder()
      .domain(Identity.unwrap(domain): java.lang.String)
      .startDate(Timestamp.unwrap(startDate): Instant)
      .endDate(Timestamp.unwrap(endDate): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.GetDomainStatisticsReportRequest.ReadOnly =
    zio.aws.sesv2.model.GetDomainStatisticsReportRequest.wrap(buildAwsValue())
}
object GetDomainStatisticsReportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetDomainStatisticsReportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetDomainStatisticsReportRequest =
      zio.aws.sesv2.model
        .GetDomainStatisticsReportRequest(domain, startDate, endDate)
    def domain: Identity
    def startDate: Timestamp
    def endDate: Timestamp
    def getDomain: ZIO[Any, Nothing, Identity] = ZIO.succeed(domain)
    def getStartDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startDate)
    def getEndDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetDomainStatisticsReportRequest
  ) extends zio.aws.sesv2.model.GetDomainStatisticsReportRequest.ReadOnly {
    override val domain: Identity =
      zio.aws.sesv2.model.primitives.Identity(impl.domain())
    override val startDate: Timestamp =
      zio.aws.sesv2.model.primitives.Timestamp(impl.startDate())
    override val endDate: Timestamp =
      zio.aws.sesv2.model.primitives.Timestamp(impl.endDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetDomainStatisticsReportRequest
  ): zio.aws.sesv2.model.GetDomainStatisticsReportRequest.ReadOnly =
    new Wrapper(impl)
}
