package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.EmailTemplateName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetCustomVerificationEmailTemplateRequest(
    templateName: EmailTemplateName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetCustomVerificationEmailTemplateRequest = {
    import GetCustomVerificationEmailTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetCustomVerificationEmailTemplateRequest
      .builder()
      .templateName(EmailTemplateName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.GetCustomVerificationEmailTemplateRequest.ReadOnly =
    zio.aws.sesv2.model.GetCustomVerificationEmailTemplateRequest
      .wrap(buildAwsValue())
}
object GetCustomVerificationEmailTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetCustomVerificationEmailTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.GetCustomVerificationEmailTemplateRequest =
      zio.aws.sesv2.model
        .GetCustomVerificationEmailTemplateRequest(templateName)
    def templateName: EmailTemplateName
    def getTemplateName: ZIO[Any, Nothing, EmailTemplateName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetCustomVerificationEmailTemplateRequest
  ) extends zio.aws.sesv2.model.GetCustomVerificationEmailTemplateRequest.ReadOnly {
    override val templateName: EmailTemplateName =
      zio.aws.sesv2.model.primitives.EmailTemplateName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetCustomVerificationEmailTemplateRequest
  ): zio.aws.sesv2.model.GetCustomVerificationEmailTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
