package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{
  EmailTemplateHtml,
  EmailTemplateText,
  EmailTemplateSubject
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EmailTemplateContent(
    subject: Option[EmailTemplateSubject] = None,
    text: Option[EmailTemplateText] = None,
    html: Option[EmailTemplateHtml] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.EmailTemplateContent = {
    import EmailTemplateContent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.EmailTemplateContent
      .builder()
      .optionallyWith(
        subject.map(value =>
          EmailTemplateSubject.unwrap(value): java.lang.String
        )
      )(_.subject)
      .optionallyWith(
        text.map(value => EmailTemplateText.unwrap(value): java.lang.String)
      )(_.text)
      .optionallyWith(
        html.map(value => EmailTemplateHtml.unwrap(value): java.lang.String)
      )(_.html)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.EmailTemplateContent.ReadOnly =
    zio.aws.sesv2.model.EmailTemplateContent.wrap(buildAwsValue())
}
object EmailTemplateContent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.EmailTemplateContent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.EmailTemplateContent =
      zio.aws.sesv2.model.EmailTemplateContent(
        subject.map(value => value),
        text.map(value => value),
        html.map(value => value)
      )
    def subject: Option[EmailTemplateSubject]
    def text: Option[EmailTemplateText]
    def html: Option[EmailTemplateHtml]
    def getSubject: ZIO[Any, AwsError, EmailTemplateSubject] =
      AwsError.unwrapOptionField("subject", subject)
    def getText: ZIO[Any, AwsError, EmailTemplateText] =
      AwsError.unwrapOptionField("text", text)
    def getHtml: ZIO[Any, AwsError, EmailTemplateHtml] =
      AwsError.unwrapOptionField("html", html)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.EmailTemplateContent
  ) extends zio.aws.sesv2.model.EmailTemplateContent.ReadOnly {
    override val subject: Option[EmailTemplateSubject] = scala
      .Option(impl.subject())
      .map(value => zio.aws.sesv2.model.primitives.EmailTemplateSubject(value))
    override val text: Option[EmailTemplateText] = scala
      .Option(impl.text())
      .map(value => zio.aws.sesv2.model.primitives.EmailTemplateText(value))
    override val html: Option[EmailTemplateHtml] = scala
      .Option(impl.html())
      .map(value => zio.aws.sesv2.model.primitives.EmailTemplateHtml(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.EmailTemplateContent
  ): zio.aws.sesv2.model.EmailTemplateContent.ReadOnly = new Wrapper(impl)
}
