package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{Timestamp, DnsToken, Enabled}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DkimAttributes(
    signingEnabled: Option[Enabled] = None,
    status: Option[zio.aws.sesv2.model.DkimStatus] = None,
    tokens: Option[Iterable[DnsToken]] = None,
    signingAttributesOrigin: Option[
      zio.aws.sesv2.model.DkimSigningAttributesOrigin
    ] = None,
    nextSigningKeyLength: Option[zio.aws.sesv2.model.DkimSigningKeyLength] =
      None,
    currentSigningKeyLength: Option[zio.aws.sesv2.model.DkimSigningKeyLength] =
      None,
    lastKeyGenerationTimestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.DkimAttributes = {
    import DkimAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.DkimAttributes
      .builder()
      .optionallyWith(
        signingEnabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.signingEnabled)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        tokens.map(value =>
          value.map { item =>
            DnsToken.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tokens)
      .optionallyWith(signingAttributesOrigin.map(value => value.unwrap))(
        _.signingAttributesOrigin
      )
      .optionallyWith(nextSigningKeyLength.map(value => value.unwrap))(
        _.nextSigningKeyLength
      )
      .optionallyWith(currentSigningKeyLength.map(value => value.unwrap))(
        _.currentSigningKeyLength
      )
      .optionallyWith(
        lastKeyGenerationTimestamp.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.lastKeyGenerationTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.DkimAttributes.ReadOnly =
    zio.aws.sesv2.model.DkimAttributes.wrap(buildAwsValue())
}
object DkimAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.DkimAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.DkimAttributes =
      zio.aws.sesv2.model.DkimAttributes(
        signingEnabled.map(value => value),
        status.map(value => value),
        tokens.map(value => value),
        signingAttributesOrigin.map(value => value),
        nextSigningKeyLength.map(value => value),
        currentSigningKeyLength.map(value => value),
        lastKeyGenerationTimestamp.map(value => value)
      )
    def signingEnabled: Option[Enabled]
    def status: Option[zio.aws.sesv2.model.DkimStatus]
    def tokens: Option[List[DnsToken]]
    def signingAttributesOrigin
        : Option[zio.aws.sesv2.model.DkimSigningAttributesOrigin]
    def nextSigningKeyLength: Option[zio.aws.sesv2.model.DkimSigningKeyLength]
    def currentSigningKeyLength
        : Option[zio.aws.sesv2.model.DkimSigningKeyLength]
    def lastKeyGenerationTimestamp: Option[Timestamp]
    def getSigningEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("signingEnabled", signingEnabled)
    def getStatus: ZIO[Any, AwsError, zio.aws.sesv2.model.DkimStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTokens: ZIO[Any, AwsError, List[DnsToken]] =
      AwsError.unwrapOptionField("tokens", tokens)
    def getSigningAttributesOrigin
        : ZIO[Any, AwsError, zio.aws.sesv2.model.DkimSigningAttributesOrigin] =
      AwsError.unwrapOptionField(
        "signingAttributesOrigin",
        signingAttributesOrigin
      )
    def getNextSigningKeyLength
        : ZIO[Any, AwsError, zio.aws.sesv2.model.DkimSigningKeyLength] =
      AwsError.unwrapOptionField("nextSigningKeyLength", nextSigningKeyLength)
    def getCurrentSigningKeyLength
        : ZIO[Any, AwsError, zio.aws.sesv2.model.DkimSigningKeyLength] =
      AwsError.unwrapOptionField(
        "currentSigningKeyLength",
        currentSigningKeyLength
      )
    def getLastKeyGenerationTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "lastKeyGenerationTimestamp",
        lastKeyGenerationTimestamp
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.DkimAttributes
  ) extends zio.aws.sesv2.model.DkimAttributes.ReadOnly {
    override val signingEnabled: Option[Enabled] = scala
      .Option(impl.signingEnabled())
      .map(value => zio.aws.sesv2.model.primitives.Enabled(value))
    override val status: Option[zio.aws.sesv2.model.DkimStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.sesv2.model.DkimStatus.wrap(value))
    override val tokens: Option[List[DnsToken]] = scala
      .Option(impl.tokens())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.primitives.DnsToken(item)
        }.toList
      )
    override val signingAttributesOrigin
        : Option[zio.aws.sesv2.model.DkimSigningAttributesOrigin] = scala
      .Option(impl.signingAttributesOrigin())
      .map(value => zio.aws.sesv2.model.DkimSigningAttributesOrigin.wrap(value))
    override val nextSigningKeyLength
        : Option[zio.aws.sesv2.model.DkimSigningKeyLength] = scala
      .Option(impl.nextSigningKeyLength())
      .map(value => zio.aws.sesv2.model.DkimSigningKeyLength.wrap(value))
    override val currentSigningKeyLength
        : Option[zio.aws.sesv2.model.DkimSigningKeyLength] = scala
      .Option(impl.currentSigningKeyLength())
      .map(value => zio.aws.sesv2.model.DkimSigningKeyLength.wrap(value))
    override val lastKeyGenerationTimestamp: Option[Timestamp] = scala
      .Option(impl.lastKeyGenerationTimestamp())
      .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.DkimAttributes
  ): zio.aws.sesv2.model.DkimAttributes.ReadOnly = new Wrapper(impl)
}
