package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.JobId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateImportJobResponse(jobId: Option[JobId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.CreateImportJobResponse = {
    import CreateImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.CreateImportJobResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.CreateImportJobResponse.ReadOnly =
    zio.aws.sesv2.model.CreateImportJobResponse.wrap(buildAwsValue())
}
object CreateImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.CreateImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.CreateImportJobResponse =
      zio.aws.sesv2.model.CreateImportJobResponse(jobId.map(value => value))
    def jobId: Option[JobId]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.CreateImportJobResponse
  ) extends zio.aws.sesv2.model.CreateImportJobResponse.ReadOnly {
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.sesv2.model.primitives.JobId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.CreateImportJobResponse
  ): zio.aws.sesv2.model.CreateImportJobResponse.ReadOnly = new Wrapper(impl)
}
