package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.Enabled
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateEmailIdentityResponse(
    identityType: Option[zio.aws.sesv2.model.IdentityType] = None,
    verifiedForSendingStatus: Option[Enabled] = None,
    dkimAttributes: Option[zio.aws.sesv2.model.DkimAttributes] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityResponse = {
    import CreateEmailIdentityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityResponse
      .builder()
      .optionallyWith(identityType.map(value => value.unwrap))(_.identityType)
      .optionallyWith(
        verifiedForSendingStatus.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.verifiedForSendingStatus)
      .optionallyWith(dkimAttributes.map(value => value.buildAwsValue()))(
        _.dkimAttributes
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.CreateEmailIdentityResponse.ReadOnly =
    zio.aws.sesv2.model.CreateEmailIdentityResponse.wrap(buildAwsValue())
}
object CreateEmailIdentityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.CreateEmailIdentityResponse =
      zio.aws.sesv2.model.CreateEmailIdentityResponse(
        identityType.map(value => value),
        verifiedForSendingStatus.map(value => value),
        dkimAttributes.map(value => value.asEditable)
      )
    def identityType: Option[zio.aws.sesv2.model.IdentityType]
    def verifiedForSendingStatus: Option[Enabled]
    def dkimAttributes: Option[zio.aws.sesv2.model.DkimAttributes.ReadOnly]
    def getIdentityType: ZIO[Any, AwsError, zio.aws.sesv2.model.IdentityType] =
      AwsError.unwrapOptionField("identityType", identityType)
    def getVerifiedForSendingStatus: ZIO[Any, AwsError, Enabled] = AwsError
      .unwrapOptionField("verifiedForSendingStatus", verifiedForSendingStatus)
    def getDkimAttributes
        : ZIO[Any, AwsError, zio.aws.sesv2.model.DkimAttributes.ReadOnly] =
      AwsError.unwrapOptionField("dkimAttributes", dkimAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityResponse
  ) extends zio.aws.sesv2.model.CreateEmailIdentityResponse.ReadOnly {
    override val identityType: Option[zio.aws.sesv2.model.IdentityType] = scala
      .Option(impl.identityType())
      .map(value => zio.aws.sesv2.model.IdentityType.wrap(value))
    override val verifiedForSendingStatus: Option[Enabled] = scala
      .Option(impl.verifiedForSendingStatus())
      .map(value => zio.aws.sesv2.model.primitives.Enabled(value))
    override val dkimAttributes
        : Option[zio.aws.sesv2.model.DkimAttributes.ReadOnly] = scala
      .Option(impl.dkimAttributes())
      .map(value => zio.aws.sesv2.model.DkimAttributes.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityResponse
  ): zio.aws.sesv2.model.CreateEmailIdentityResponse.ReadOnly = new Wrapper(
    impl
  )
}
