package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{EmailAddress, ReportName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDeliverabilityTestReportRequest(
    reportName: Option[ReportName] = None,
    fromEmailAddress: EmailAddress,
    content: zio.aws.sesv2.model.EmailContent,
    tags: Option[Iterable[zio.aws.sesv2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.CreateDeliverabilityTestReportRequest = {
    import CreateDeliverabilityTestReportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.CreateDeliverabilityTestReportRequest
      .builder()
      .optionallyWith(
        reportName.map(value => ReportName.unwrap(value): java.lang.String)
      )(_.reportName)
      .fromEmailAddress(EmailAddress.unwrap(fromEmailAddress): java.lang.String)
      .content(content.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.CreateDeliverabilityTestReportRequest.ReadOnly =
    zio.aws.sesv2.model.CreateDeliverabilityTestReportRequest
      .wrap(buildAwsValue())
}
object CreateDeliverabilityTestReportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.CreateDeliverabilityTestReportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.CreateDeliverabilityTestReportRequest =
      zio.aws.sesv2.model.CreateDeliverabilityTestReportRequest(
        reportName.map(value => value),
        fromEmailAddress,
        content.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def reportName: Option[ReportName]
    def fromEmailAddress: EmailAddress
    def content: zio.aws.sesv2.model.EmailContent.ReadOnly
    def tags: Option[List[zio.aws.sesv2.model.Tag.ReadOnly]]
    def getReportName: ZIO[Any, AwsError, ReportName] =
      AwsError.unwrapOptionField("reportName", reportName)
    def getFromEmailAddress: ZIO[Any, Nothing, EmailAddress] =
      ZIO.succeed(fromEmailAddress)
    def getContent
        : ZIO[Any, Nothing, zio.aws.sesv2.model.EmailContent.ReadOnly] =
      ZIO.succeed(content)
    def getTags: ZIO[Any, AwsError, List[zio.aws.sesv2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.CreateDeliverabilityTestReportRequest
  ) extends zio.aws.sesv2.model.CreateDeliverabilityTestReportRequest.ReadOnly {
    override val reportName: Option[ReportName] = scala
      .Option(impl.reportName())
      .map(value => zio.aws.sesv2.model.primitives.ReportName(value))
    override val fromEmailAddress: EmailAddress =
      zio.aws.sesv2.model.primitives.EmailAddress(impl.fromEmailAddress())
    override val content: zio.aws.sesv2.model.EmailContent.ReadOnly =
      zio.aws.sesv2.model.EmailContent.wrap(impl.content())
    override val tags: Option[List[zio.aws.sesv2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.CreateDeliverabilityTestReportRequest
  ): zio.aws.sesv2.model.CreateDeliverabilityTestReportRequest.ReadOnly =
    new Wrapper(impl)
}
