package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.ConfigurationSetName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateConfigurationSetRequest(
    configurationSetName: ConfigurationSetName,
    trackingOptions: Option[zio.aws.sesv2.model.TrackingOptions] = None,
    deliveryOptions: Option[zio.aws.sesv2.model.DeliveryOptions] = None,
    reputationOptions: Option[zio.aws.sesv2.model.ReputationOptions] = None,
    sendingOptions: Option[zio.aws.sesv2.model.SendingOptions] = None,
    tags: Option[Iterable[zio.aws.sesv2.model.Tag]] = None,
    suppressionOptions: Option[zio.aws.sesv2.model.SuppressionOptions] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetRequest = {
    import CreateConfigurationSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .optionallyWith(trackingOptions.map(value => value.buildAwsValue()))(
        _.trackingOptions
      )
      .optionallyWith(deliveryOptions.map(value => value.buildAwsValue()))(
        _.deliveryOptions
      )
      .optionallyWith(reputationOptions.map(value => value.buildAwsValue()))(
        _.reputationOptions
      )
      .optionallyWith(sendingOptions.map(value => value.buildAwsValue()))(
        _.sendingOptions
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(suppressionOptions.map(value => value.buildAwsValue()))(
        _.suppressionOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.CreateConfigurationSetRequest.ReadOnly =
    zio.aws.sesv2.model.CreateConfigurationSetRequest.wrap(buildAwsValue())
}
object CreateConfigurationSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.CreateConfigurationSetRequest =
      zio.aws.sesv2.model.CreateConfigurationSetRequest(
        configurationSetName,
        trackingOptions.map(value => value.asEditable),
        deliveryOptions.map(value => value.asEditable),
        reputationOptions.map(value => value.asEditable),
        sendingOptions.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        suppressionOptions.map(value => value.asEditable)
      )
    def configurationSetName: ConfigurationSetName
    def trackingOptions: Option[zio.aws.sesv2.model.TrackingOptions.ReadOnly]
    def deliveryOptions: Option[zio.aws.sesv2.model.DeliveryOptions.ReadOnly]
    def reputationOptions
        : Option[zio.aws.sesv2.model.ReputationOptions.ReadOnly]
    def sendingOptions: Option[zio.aws.sesv2.model.SendingOptions.ReadOnly]
    def tags: Option[List[zio.aws.sesv2.model.Tag.ReadOnly]]
    def suppressionOptions
        : Option[zio.aws.sesv2.model.SuppressionOptions.ReadOnly]
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getTrackingOptions
        : ZIO[Any, AwsError, zio.aws.sesv2.model.TrackingOptions.ReadOnly] =
      AwsError.unwrapOptionField("trackingOptions", trackingOptions)
    def getDeliveryOptions
        : ZIO[Any, AwsError, zio.aws.sesv2.model.DeliveryOptions.ReadOnly] =
      AwsError.unwrapOptionField("deliveryOptions", deliveryOptions)
    def getReputationOptions
        : ZIO[Any, AwsError, zio.aws.sesv2.model.ReputationOptions.ReadOnly] =
      AwsError.unwrapOptionField("reputationOptions", reputationOptions)
    def getSendingOptions
        : ZIO[Any, AwsError, zio.aws.sesv2.model.SendingOptions.ReadOnly] =
      AwsError.unwrapOptionField("sendingOptions", sendingOptions)
    def getTags: ZIO[Any, AwsError, List[zio.aws.sesv2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSuppressionOptions
        : ZIO[Any, AwsError, zio.aws.sesv2.model.SuppressionOptions.ReadOnly] =
      AwsError.unwrapOptionField("suppressionOptions", suppressionOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetRequest
  ) extends zio.aws.sesv2.model.CreateConfigurationSetRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.sesv2.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val trackingOptions
        : Option[zio.aws.sesv2.model.TrackingOptions.ReadOnly] = scala
      .Option(impl.trackingOptions())
      .map(value => zio.aws.sesv2.model.TrackingOptions.wrap(value))
    override val deliveryOptions
        : Option[zio.aws.sesv2.model.DeliveryOptions.ReadOnly] = scala
      .Option(impl.deliveryOptions())
      .map(value => zio.aws.sesv2.model.DeliveryOptions.wrap(value))
    override val reputationOptions
        : Option[zio.aws.sesv2.model.ReputationOptions.ReadOnly] = scala
      .Option(impl.reputationOptions())
      .map(value => zio.aws.sesv2.model.ReputationOptions.wrap(value))
    override val sendingOptions
        : Option[zio.aws.sesv2.model.SendingOptions.ReadOnly] = scala
      .Option(impl.sendingOptions())
      .map(value => zio.aws.sesv2.model.SendingOptions.wrap(value))
    override val tags: Option[List[zio.aws.sesv2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.Tag.wrap(item)
        }.toList
      )
    override val suppressionOptions
        : Option[zio.aws.sesv2.model.SuppressionOptions.ReadOnly] = scala
      .Option(impl.suppressionOptions())
      .map(value => zio.aws.sesv2.model.SuppressionOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetRequest
  ): zio.aws.sesv2.model.CreateConfigurationSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
