package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{
  ConfigurationSetName,
  EmailTemplateName,
  EmailAddress
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SendCustomVerificationEmailRequest(
    emailAddress: EmailAddress,
    templateName: EmailTemplateName,
    configurationSetName: Option[ConfigurationSetName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.SendCustomVerificationEmailRequest = {
    import SendCustomVerificationEmailRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.SendCustomVerificationEmailRequest
      .builder()
      .emailAddress(EmailAddress.unwrap(emailAddress): java.lang.String)
      .templateName(EmailTemplateName.unwrap(templateName): java.lang.String)
      .optionallyWith(
        configurationSetName.map(value =>
          ConfigurationSetName.unwrap(value): java.lang.String
        )
      )(_.configurationSetName)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.SendCustomVerificationEmailRequest.ReadOnly =
    zio.aws.sesv2.model.SendCustomVerificationEmailRequest.wrap(buildAwsValue())
}
object SendCustomVerificationEmailRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.SendCustomVerificationEmailRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.SendCustomVerificationEmailRequest =
      zio.aws.sesv2.model.SendCustomVerificationEmailRequest(
        emailAddress,
        templateName,
        configurationSetName.map(value => value)
      )
    def emailAddress: EmailAddress
    def templateName: EmailTemplateName
    def configurationSetName: Option[ConfigurationSetName]
    def getEmailAddress: ZIO[Any, Nothing, EmailAddress] =
      ZIO.succeed(emailAddress)
    def getTemplateName: ZIO[Any, Nothing, EmailTemplateName] =
      ZIO.succeed(templateName)
    def getConfigurationSetName: ZIO[Any, AwsError, ConfigurationSetName] =
      AwsError.unwrapOptionField("configurationSetName", configurationSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.SendCustomVerificationEmailRequest
  ) extends zio.aws.sesv2.model.SendCustomVerificationEmailRequest.ReadOnly {
    override val emailAddress: EmailAddress =
      zio.aws.sesv2.model.primitives.EmailAddress(impl.emailAddress())
    override val templateName: EmailTemplateName =
      zio.aws.sesv2.model.primitives.EmailTemplateName(impl.templateName())
    override val configurationSetName: Option[ConfigurationSetName] = scala
      .Option(impl.configurationSetName())
      .map(value => zio.aws.sesv2.model.primitives.ConfigurationSetName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.SendCustomVerificationEmailRequest
  ): zio.aws.sesv2.model.SendCustomVerificationEmailRequest.ReadOnly =
    new Wrapper(impl)
}
