package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{Timestamp, Description, ContactListName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GetContactListResponse(
    contactListName: Option[ContactListName] = None,
    topics: Option[Iterable[zio.aws.sesv2.model.Topic]] = None,
    description: Option[Description] = None,
    createdTimestamp: Option[Timestamp] = None,
    lastUpdatedTimestamp: Option[Timestamp] = None,
    tags: Option[Iterable[zio.aws.sesv2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetContactListResponse = {
    import GetContactListResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetContactListResponse
      .builder()
      .optionallyWith(
        contactListName.map(value =>
          ContactListName.unwrap(value): java.lang.String
        )
      )(_.contactListName)
      .optionallyWith(
        topics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.topics)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetContactListResponse.ReadOnly =
    zio.aws.sesv2.model.GetContactListResponse.wrap(buildAwsValue())
}
object GetContactListResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetContactListResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetContactListResponse =
      zio.aws.sesv2.model.GetContactListResponse(
        contactListName.map(value => value),
        topics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        description.map(value => value),
        createdTimestamp.map(value => value),
        lastUpdatedTimestamp.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def contactListName: Option[ContactListName]
    def topics: Option[List[zio.aws.sesv2.model.Topic.ReadOnly]]
    def description: Option[Description]
    def createdTimestamp: Option[Timestamp]
    def lastUpdatedTimestamp: Option[Timestamp]
    def tags: Option[List[zio.aws.sesv2.model.Tag.ReadOnly]]
    def getContactListName: ZIO[Any, AwsError, ContactListName] =
      AwsError.unwrapOptionField("contactListName", contactListName)
    def getTopics
        : ZIO[Any, AwsError, List[zio.aws.sesv2.model.Topic.ReadOnly]] =
      AwsError.unwrapOptionField("topics", topics)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
    def getTags: ZIO[Any, AwsError, List[zio.aws.sesv2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetContactListResponse
  ) extends zio.aws.sesv2.model.GetContactListResponse.ReadOnly {
    override val contactListName: Option[ContactListName] = scala
      .Option(impl.contactListName())
      .map(value => zio.aws.sesv2.model.primitives.ContactListName(value))
    override val topics: Option[List[zio.aws.sesv2.model.Topic.ReadOnly]] =
      scala
        .Option(impl.topics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.Topic.wrap(item)
          }.toList
        )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.sesv2.model.primitives.Description(value))
    override val createdTimestamp: Option[Timestamp] = scala
      .Option(impl.createdTimestamp())
      .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
    override val lastUpdatedTimestamp: Option[Timestamp] = scala
      .Option(impl.lastUpdatedTimestamp())
      .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
    override val tags: Option[List[zio.aws.sesv2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetContactListResponse
  ): zio.aws.sesv2.model.GetContactListResponse.ReadOnly = new Wrapper(impl)
}
