package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.BlacklistItemName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetBlacklistReportsResponse(
    blacklistReport: Map[BlacklistItemName, Iterable[
      zio.aws.sesv2.model.BlacklistEntry
    ]]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetBlacklistReportsResponse = {
    import GetBlacklistReportsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetBlacklistReportsResponse
      .builder()
      .blacklistReport(
        blacklistReport
          .map({ case (key, value) =>
            (BlacklistItemName.unwrap(key): java.lang.String) -> value.map {
              item =>
                item.buildAwsValue()
            }.asJavaCollection
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetBlacklistReportsResponse.ReadOnly =
    zio.aws.sesv2.model.GetBlacklistReportsResponse.wrap(buildAwsValue())
}
object GetBlacklistReportsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetBlacklistReportsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetBlacklistReportsResponse =
      zio.aws.sesv2.model.GetBlacklistReportsResponse(blacklistReport.map({
        case (key, value) =>
          key -> value.map { item =>
            item.asEditable
          }
      }))
    def blacklistReport: Map[BlacklistItemName, List[
      zio.aws.sesv2.model.BlacklistEntry.ReadOnly
    ]]
    def getBlacklistReport: ZIO[Any, Nothing, Map[BlacklistItemName, List[
      zio.aws.sesv2.model.BlacklistEntry.ReadOnly
    ]]] = ZIO.succeed(blacklistReport)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetBlacklistReportsResponse
  ) extends zio.aws.sesv2.model.GetBlacklistReportsResponse.ReadOnly {
    override val blacklistReport: Map[BlacklistItemName, List[
      zio.aws.sesv2.model.BlacklistEntry.ReadOnly
    ]] = impl
      .blacklistReport()
      .asScala
      .map({ case (key, value) =>
        zio.aws.sesv2.model.primitives
          .BlacklistItemName(key) -> value.asScala.map { item =>
          zio.aws.sesv2.model.BlacklistEntry.wrap(item)
        }.toList
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetBlacklistReportsResponse
  ): zio.aws.sesv2.model.GetBlacklistReportsResponse.ReadOnly = new Wrapper(
    impl
  )
}
