package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{
  EventDestinationName,
  ConfigurationSetName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteConfigurationSetEventDestinationRequest(
    configurationSetName: ConfigurationSetName,
    eventDestinationName: EventDestinationName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetEventDestinationRequest = {
    import DeleteConfigurationSetEventDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetEventDestinationRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .eventDestinationName(
        EventDestinationName.unwrap(eventDestinationName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.DeleteConfigurationSetEventDestinationRequest.ReadOnly =
    zio.aws.sesv2.model.DeleteConfigurationSetEventDestinationRequest
      .wrap(buildAwsValue())
}
object DeleteConfigurationSetEventDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetEventDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.DeleteConfigurationSetEventDestinationRequest =
      zio.aws.sesv2.model.DeleteConfigurationSetEventDestinationRequest(
        configurationSetName,
        eventDestinationName
      )
    def configurationSetName: ConfigurationSetName
    def eventDestinationName: EventDestinationName
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getEventDestinationName: ZIO[Any, Nothing, EventDestinationName] =
      ZIO.succeed(eventDestinationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetEventDestinationRequest
  ) extends zio.aws.sesv2.model.DeleteConfigurationSetEventDestinationRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.sesv2.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val eventDestinationName: EventDestinationName =
      zio.aws.sesv2.model.primitives
        .EventDestinationName(impl.eventDestinationName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetEventDestinationRequest
  ): zio.aws.sesv2.model.DeleteConfigurationSetEventDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
