package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{ConfigurationSetName, Identity}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateEmailIdentityRequest(
    emailIdentity: Identity,
    tags: Option[Iterable[zio.aws.sesv2.model.Tag]] = None,
    dkimSigningAttributes: Option[zio.aws.sesv2.model.DkimSigningAttributes] =
      None,
    configurationSetName: Option[ConfigurationSetName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityRequest = {
    import CreateEmailIdentityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityRequest
      .builder()
      .emailIdentity(Identity.unwrap(emailIdentity): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        dkimSigningAttributes.map(value => value.buildAwsValue())
      )(_.dkimSigningAttributes)
      .optionallyWith(
        configurationSetName.map(value =>
          ConfigurationSetName.unwrap(value): java.lang.String
        )
      )(_.configurationSetName)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.CreateEmailIdentityRequest.ReadOnly =
    zio.aws.sesv2.model.CreateEmailIdentityRequest.wrap(buildAwsValue())
}
object CreateEmailIdentityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.CreateEmailIdentityRequest =
      zio.aws.sesv2.model.CreateEmailIdentityRequest(
        emailIdentity,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dkimSigningAttributes.map(value => value.asEditable),
        configurationSetName.map(value => value)
      )
    def emailIdentity: Identity
    def tags: Option[List[zio.aws.sesv2.model.Tag.ReadOnly]]
    def dkimSigningAttributes
        : Option[zio.aws.sesv2.model.DkimSigningAttributes.ReadOnly]
    def configurationSetName: Option[ConfigurationSetName]
    def getEmailIdentity: ZIO[Any, Nothing, Identity] =
      ZIO.succeed(emailIdentity)
    def getTags: ZIO[Any, AwsError, List[zio.aws.sesv2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDkimSigningAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.sesv2.model.DkimSigningAttributes.ReadOnly
    ] =
      AwsError.unwrapOptionField("dkimSigningAttributes", dkimSigningAttributes)
    def getConfigurationSetName: ZIO[Any, AwsError, ConfigurationSetName] =
      AwsError.unwrapOptionField("configurationSetName", configurationSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityRequest
  ) extends zio.aws.sesv2.model.CreateEmailIdentityRequest.ReadOnly {
    override val emailIdentity: Identity =
      zio.aws.sesv2.model.primitives.Identity(impl.emailIdentity())
    override val tags: Option[List[zio.aws.sesv2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.Tag.wrap(item)
        }.toList
      )
    override val dkimSigningAttributes
        : Option[zio.aws.sesv2.model.DkimSigningAttributes.ReadOnly] = scala
      .Option(impl.dkimSigningAttributes())
      .map(value => zio.aws.sesv2.model.DkimSigningAttributes.wrap(value))
    override val configurationSetName: Option[ConfigurationSetName] = scala
      .Option(impl.configurationSetName())
      .map(value => zio.aws.sesv2.model.primitives.ConfigurationSetName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityRequest
  ): zio.aws.sesv2.model.CreateEmailIdentityRequest.ReadOnly = new Wrapper(impl)
}
