package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{
  ConfigurationSetName,
  AmazonResourceName,
  EmailAddress
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SendEmailRequest(
    fromEmailAddress: Option[EmailAddress] = None,
    fromEmailAddressIdentityArn: Option[AmazonResourceName] = None,
    destination: Option[zio.aws.sesv2.model.Destination] = None,
    replyToAddresses: Option[Iterable[EmailAddress]] = None,
    feedbackForwardingEmailAddress: Option[EmailAddress] = None,
    feedbackForwardingEmailAddressIdentityArn: Option[AmazonResourceName] =
      None,
    content: zio.aws.sesv2.model.EmailContent,
    emailTags: Option[Iterable[zio.aws.sesv2.model.MessageTag]] = None,
    configurationSetName: Option[ConfigurationSetName] = None,
    listManagementOptions: Option[zio.aws.sesv2.model.ListManagementOptions] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.SendEmailRequest = {
    import SendEmailRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.SendEmailRequest
      .builder()
      .optionallyWith(
        fromEmailAddress.map(value =>
          EmailAddress.unwrap(value): java.lang.String
        )
      )(_.fromEmailAddress)
      .optionallyWith(
        fromEmailAddressIdentityArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.fromEmailAddressIdentityArn)
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .optionallyWith(
        replyToAddresses.map(value =>
          value.map { item =>
            EmailAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.replyToAddresses)
      .optionallyWith(
        feedbackForwardingEmailAddress.map(value =>
          EmailAddress.unwrap(value): java.lang.String
        )
      )(_.feedbackForwardingEmailAddress)
      .optionallyWith(
        feedbackForwardingEmailAddressIdentityArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.feedbackForwardingEmailAddressIdentityArn)
      .content(content.buildAwsValue())
      .optionallyWith(
        emailTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.emailTags)
      .optionallyWith(
        configurationSetName.map(value =>
          ConfigurationSetName.unwrap(value): java.lang.String
        )
      )(_.configurationSetName)
      .optionallyWith(
        listManagementOptions.map(value => value.buildAwsValue())
      )(_.listManagementOptions)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.SendEmailRequest.ReadOnly =
    zio.aws.sesv2.model.SendEmailRequest.wrap(buildAwsValue())
}
object SendEmailRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.SendEmailRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.SendEmailRequest =
      zio.aws.sesv2.model.SendEmailRequest(
        fromEmailAddress.map(value => value),
        fromEmailAddressIdentityArn.map(value => value),
        destination.map(value => value.asEditable),
        replyToAddresses.map(value => value),
        feedbackForwardingEmailAddress.map(value => value),
        feedbackForwardingEmailAddressIdentityArn.map(value => value),
        content.asEditable,
        emailTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configurationSetName.map(value => value),
        listManagementOptions.map(value => value.asEditable)
      )
    def fromEmailAddress: Option[EmailAddress]
    def fromEmailAddressIdentityArn: Option[AmazonResourceName]
    def destination: Option[zio.aws.sesv2.model.Destination.ReadOnly]
    def replyToAddresses: Option[List[EmailAddress]]
    def feedbackForwardingEmailAddress: Option[EmailAddress]
    def feedbackForwardingEmailAddressIdentityArn: Option[AmazonResourceName]
    def content: zio.aws.sesv2.model.EmailContent.ReadOnly
    def emailTags: Option[List[zio.aws.sesv2.model.MessageTag.ReadOnly]]
    def configurationSetName: Option[ConfigurationSetName]
    def listManagementOptions
        : Option[zio.aws.sesv2.model.ListManagementOptions.ReadOnly]
    def getFromEmailAddress: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField("fromEmailAddress", fromEmailAddress)
    def getFromEmailAddressIdentityArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField(
        "fromEmailAddressIdentityArn",
        fromEmailAddressIdentityArn
      )
    def getDestination
        : ZIO[Any, AwsError, zio.aws.sesv2.model.Destination.ReadOnly] =
      AwsError.unwrapOptionField("destination", destination)
    def getReplyToAddresses: ZIO[Any, AwsError, List[EmailAddress]] =
      AwsError.unwrapOptionField("replyToAddresses", replyToAddresses)
    def getFeedbackForwardingEmailAddress: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField(
        "feedbackForwardingEmailAddress",
        feedbackForwardingEmailAddress
      )
    def getFeedbackForwardingEmailAddressIdentityArn
        : ZIO[Any, AwsError, AmazonResourceName] = AwsError.unwrapOptionField(
      "feedbackForwardingEmailAddressIdentityArn",
      feedbackForwardingEmailAddressIdentityArn
    )
    def getContent
        : ZIO[Any, Nothing, zio.aws.sesv2.model.EmailContent.ReadOnly] =
      ZIO.succeed(content)
    def getEmailTags
        : ZIO[Any, AwsError, List[zio.aws.sesv2.model.MessageTag.ReadOnly]] =
      AwsError.unwrapOptionField("emailTags", emailTags)
    def getConfigurationSetName: ZIO[Any, AwsError, ConfigurationSetName] =
      AwsError.unwrapOptionField("configurationSetName", configurationSetName)
    def getListManagementOptions: ZIO[
      Any,
      AwsError,
      zio.aws.sesv2.model.ListManagementOptions.ReadOnly
    ] =
      AwsError.unwrapOptionField("listManagementOptions", listManagementOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.SendEmailRequest
  ) extends zio.aws.sesv2.model.SendEmailRequest.ReadOnly {
    override val fromEmailAddress: Option[EmailAddress] = scala
      .Option(impl.fromEmailAddress())
      .map(value => zio.aws.sesv2.model.primitives.EmailAddress(value))
    override val fromEmailAddressIdentityArn: Option[AmazonResourceName] = scala
      .Option(impl.fromEmailAddressIdentityArn())
      .map(value => zio.aws.sesv2.model.primitives.AmazonResourceName(value))
    override val destination: Option[zio.aws.sesv2.model.Destination.ReadOnly] =
      scala
        .Option(impl.destination())
        .map(value => zio.aws.sesv2.model.Destination.wrap(value))
    override val replyToAddresses: Option[List[EmailAddress]] = scala
      .Option(impl.replyToAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.primitives.EmailAddress(item)
        }.toList
      )
    override val feedbackForwardingEmailAddress: Option[EmailAddress] = scala
      .Option(impl.feedbackForwardingEmailAddress())
      .map(value => zio.aws.sesv2.model.primitives.EmailAddress(value))
    override val feedbackForwardingEmailAddressIdentityArn
        : Option[AmazonResourceName] = scala
      .Option(impl.feedbackForwardingEmailAddressIdentityArn())
      .map(value => zio.aws.sesv2.model.primitives.AmazonResourceName(value))
    override val content: zio.aws.sesv2.model.EmailContent.ReadOnly =
      zio.aws.sesv2.model.EmailContent.wrap(impl.content())
    override val emailTags
        : Option[List[zio.aws.sesv2.model.MessageTag.ReadOnly]] = scala
      .Option(impl.emailTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.MessageTag.wrap(item)
        }.toList
      )
    override val configurationSetName: Option[ConfigurationSetName] = scala
      .Option(impl.configurationSetName())
      .map(value => zio.aws.sesv2.model.primitives.ConfigurationSetName(value))
    override val listManagementOptions
        : Option[zio.aws.sesv2.model.ListManagementOptions.ReadOnly] = scala
      .Option(impl.listManagementOptions())
      .map(value => zio.aws.sesv2.model.ListManagementOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.SendEmailRequest
  ): zio.aws.sesv2.model.SendEmailRequest.ReadOnly = new Wrapper(impl)
}
