package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ReplacementEmailContent(
    replacementTemplate: Option[zio.aws.sesv2.model.ReplacementTemplate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ReplacementEmailContent = {
    import ReplacementEmailContent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ReplacementEmailContent
      .builder()
      .optionallyWith(replacementTemplate.map(value => value.buildAwsValue()))(
        _.replacementTemplate
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ReplacementEmailContent.ReadOnly =
    zio.aws.sesv2.model.ReplacementEmailContent.wrap(buildAwsValue())
}
object ReplacementEmailContent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ReplacementEmailContent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ReplacementEmailContent =
      zio.aws.sesv2.model.ReplacementEmailContent(
        replacementTemplate.map(value => value.asEditable)
      )
    def replacementTemplate
        : Option[zio.aws.sesv2.model.ReplacementTemplate.ReadOnly]
    def getReplacementTemplate
        : ZIO[Any, AwsError, zio.aws.sesv2.model.ReplacementTemplate.ReadOnly] =
      AwsError.unwrapOptionField("replacementTemplate", replacementTemplate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ReplacementEmailContent
  ) extends zio.aws.sesv2.model.ReplacementEmailContent.ReadOnly {
    override val replacementTemplate
        : Option[zio.aws.sesv2.model.ReplacementTemplate.ReadOnly] = scala
      .Option(impl.replacementTemplate())
      .map(value => zio.aws.sesv2.model.ReplacementTemplate.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ReplacementEmailContent
  ): zio.aws.sesv2.model.ReplacementEmailContent.ReadOnly = new Wrapper(impl)
}
