package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.DnsToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutEmailIdentityDkimSigningAttributesResponse(
    dkimStatus: Option[zio.aws.sesv2.model.DkimStatus] = None,
    dkimTokens: Option[Iterable[DnsToken]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse = {
    import PutEmailIdentityDkimSigningAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse
      .builder()
      .optionallyWith(dkimStatus.map(value => value.unwrap))(_.dkimStatus)
      .optionallyWith(
        dkimTokens.map(value =>
          value.map { item =>
            DnsToken.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dkimTokens)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse.ReadOnly =
    zio.aws.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse
      .wrap(buildAwsValue())
}
object PutEmailIdentityDkimSigningAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse =
      zio.aws.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse(
        dkimStatus.map(value => value),
        dkimTokens.map(value => value)
      )
    def dkimStatus: Option[zio.aws.sesv2.model.DkimStatus]
    def dkimTokens: Option[List[DnsToken]]
    def getDkimStatus: ZIO[Any, AwsError, zio.aws.sesv2.model.DkimStatus] =
      AwsError.unwrapOptionField("dkimStatus", dkimStatus)
    def getDkimTokens: ZIO[Any, AwsError, List[DnsToken]] =
      AwsError.unwrapOptionField("dkimTokens", dkimTokens)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse
  ) extends zio.aws.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse.ReadOnly {
    override val dkimStatus: Option[zio.aws.sesv2.model.DkimStatus] = scala
      .Option(impl.dkimStatus())
      .map(value => zio.aws.sesv2.model.DkimStatus.wrap(value))
    override val dkimTokens: Option[List[DnsToken]] = scala
      .Option(impl.dkimTokens())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.primitives.DnsToken(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse
  ): zio.aws.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
