package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{Enabled, Identity}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutEmailIdentityDkimAttributesRequest(
    emailIdentity: Identity,
    signingEnabled: Option[Enabled] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimAttributesRequest = {
    import PutEmailIdentityDkimAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimAttributesRequest
      .builder()
      .emailIdentity(Identity.unwrap(emailIdentity): java.lang.String)
      .optionallyWith(
        signingEnabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.signingEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.PutEmailIdentityDkimAttributesRequest.ReadOnly =
    zio.aws.sesv2.model.PutEmailIdentityDkimAttributesRequest
      .wrap(buildAwsValue())
}
object PutEmailIdentityDkimAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.PutEmailIdentityDkimAttributesRequest =
      zio.aws.sesv2.model.PutEmailIdentityDkimAttributesRequest(
        emailIdentity,
        signingEnabled.map(value => value)
      )
    def emailIdentity: Identity
    def signingEnabled: Option[Enabled]
    def getEmailIdentity: ZIO[Any, Nothing, Identity] =
      ZIO.succeed(emailIdentity)
    def getSigningEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("signingEnabled", signingEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimAttributesRequest
  ) extends zio.aws.sesv2.model.PutEmailIdentityDkimAttributesRequest.ReadOnly {
    override val emailIdentity: Identity =
      zio.aws.sesv2.model.primitives.Identity(impl.emailIdentity())
    override val signingEnabled: Option[Enabled] = scala
      .Option(impl.signingEnabled())
      .map(value => zio.aws.sesv2.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimAttributesRequest
  ): zio.aws.sesv2.model.PutEmailIdentityDkimAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
