package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListEmailTemplatesResponse(
    templatesMetadata: Option[
      Iterable[zio.aws.sesv2.model.EmailTemplateMetadata]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesResponse = {
    import ListEmailTemplatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesResponse
      .builder()
      .optionallyWith(
        templatesMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.templatesMetadata)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ListEmailTemplatesResponse.ReadOnly =
    zio.aws.sesv2.model.ListEmailTemplatesResponse.wrap(buildAwsValue())
}
object ListEmailTemplatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ListEmailTemplatesResponse =
      zio.aws.sesv2.model.ListEmailTemplatesResponse(
        templatesMetadata.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def templatesMetadata
        : Option[List[zio.aws.sesv2.model.EmailTemplateMetadata.ReadOnly]]
    def nextToken: Option[NextToken]
    def getTemplatesMetadata: ZIO[Any, AwsError, List[
      zio.aws.sesv2.model.EmailTemplateMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("templatesMetadata", templatesMetadata)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesResponse
  ) extends zio.aws.sesv2.model.ListEmailTemplatesResponse.ReadOnly {
    override val templatesMetadata
        : Option[List[zio.aws.sesv2.model.EmailTemplateMetadata.ReadOnly]] =
      scala
        .Option(impl.templatesMetadata())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.EmailTemplateMetadata.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesResponse
  ): zio.aws.sesv2.model.ListEmailTemplatesResponse.ReadOnly = new Wrapper(impl)
}
