package zio.aws.sesv2.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sesv2.model.primitives.{MaxItems, NextToken, Domain, Timestamp}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListDomainDeliverabilityCampaignsRequest(
    startDate: Timestamp,
    endDate: Timestamp,
    subscribedDomain: Domain,
    nextToken: Option[NextToken] = None,
    pageSize: Option[MaxItems] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest = {
    import ListDomainDeliverabilityCampaignsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest
      .builder()
      .startDate(Timestamp.unwrap(startDate): Instant)
      .endDate(Timestamp.unwrap(endDate): Instant)
      .subscribedDomain(Domain.unwrap(subscribedDomain): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(pageSize.map(value => MaxItems.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.ListDomainDeliverabilityCampaignsRequest.ReadOnly =
    zio.aws.sesv2.model.ListDomainDeliverabilityCampaignsRequest
      .wrap(buildAwsValue())
}
object ListDomainDeliverabilityCampaignsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.ListDomainDeliverabilityCampaignsRequest =
      zio.aws.sesv2.model.ListDomainDeliverabilityCampaignsRequest(
        startDate,
        endDate,
        subscribedDomain,
        nextToken.map(value => value),
        pageSize.map(value => value)
      )
    def startDate: Timestamp
    def endDate: Timestamp
    def subscribedDomain: Domain
    def nextToken: Option[NextToken]
    def pageSize: Option[MaxItems]
    def getStartDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startDate)
    def getEndDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endDate)
    def getSubscribedDomain: ZIO[Any, Nothing, Domain] =
      ZIO.succeed(subscribedDomain)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPageSize: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest
  ) extends zio.aws.sesv2.model.ListDomainDeliverabilityCampaignsRequest.ReadOnly {
    override val startDate: Timestamp =
      zio.aws.sesv2.model.primitives.Timestamp(impl.startDate())
    override val endDate: Timestamp =
      zio.aws.sesv2.model.primitives.Timestamp(impl.endDate())
    override val subscribedDomain: Domain =
      zio.aws.sesv2.model.primitives.Domain(impl.subscribedDomain())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
    override val pageSize: Option[MaxItems] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.sesv2.model.primitives.MaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest
  ): zio.aws.sesv2.model.ListDomainDeliverabilityCampaignsRequest.ReadOnly =
    new Wrapper(impl)
}
