package zio.aws.sesv2.model
import java.lang.Integer
import zio.aws.sesv2.model.primitives.{NextToken, MaxItems, ContactListName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListContactsRequest(
    contactListName: ContactListName,
    filter: Option[zio.aws.sesv2.model.ListContactsFilter] = None,
    pageSize: Option[MaxItems] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListContactsRequest = {
    import ListContactsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListContactsRequest
      .builder()
      .contactListName(
        ContactListName.unwrap(contactListName): java.lang.String
      )
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(pageSize.map(value => MaxItems.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ListContactsRequest.ReadOnly =
    zio.aws.sesv2.model.ListContactsRequest.wrap(buildAwsValue())
}
object ListContactsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListContactsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ListContactsRequest =
      zio.aws.sesv2.model.ListContactsRequest(
        contactListName,
        filter.map(value => value.asEditable),
        pageSize.map(value => value),
        nextToken.map(value => value)
      )
    def contactListName: ContactListName
    def filter: Option[zio.aws.sesv2.model.ListContactsFilter.ReadOnly]
    def pageSize: Option[MaxItems]
    def nextToken: Option[NextToken]
    def getContactListName: ZIO[Any, Nothing, ContactListName] =
      ZIO.succeed(contactListName)
    def getFilter
        : ZIO[Any, AwsError, zio.aws.sesv2.model.ListContactsFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
    def getPageSize: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListContactsRequest
  ) extends zio.aws.sesv2.model.ListContactsRequest.ReadOnly {
    override val contactListName: ContactListName =
      zio.aws.sesv2.model.primitives.ContactListName(impl.contactListName())
    override val filter
        : Option[zio.aws.sesv2.model.ListContactsFilter.ReadOnly] = scala
      .Option(impl.filter())
      .map(value => zio.aws.sesv2.model.ListContactsFilter.wrap(value))
    override val pageSize: Option[MaxItems] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.sesv2.model.primitives.MaxItems(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListContactsRequest
  ): zio.aws.sesv2.model.ListContactsRequest.ReadOnly = new Wrapper(impl)
}
