package zio.aws.sesv2.model
import java.lang.Integer
import zio.aws.sesv2.model.primitives.{NextToken, MaxItems}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListContactListsRequest(
    pageSize: Option[MaxItems] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListContactListsRequest = {
    import ListContactListsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListContactListsRequest
      .builder()
      .optionallyWith(pageSize.map(value => MaxItems.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ListContactListsRequest.ReadOnly =
    zio.aws.sesv2.model.ListContactListsRequest.wrap(buildAwsValue())
}
object ListContactListsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListContactListsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ListContactListsRequest =
      zio.aws.sesv2.model.ListContactListsRequest(
        pageSize.map(value => value),
        nextToken.map(value => value)
      )
    def pageSize: Option[MaxItems]
    def nextToken: Option[NextToken]
    def getPageSize: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListContactListsRequest
  ) extends zio.aws.sesv2.model.ListContactListsRequest.ReadOnly {
    override val pageSize: Option[MaxItems] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.sesv2.model.primitives.MaxItems(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListContactListsRequest
  ): zio.aws.sesv2.model.ListContactListsRequest.ReadOnly = new Wrapper(impl)
}
