package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{Timestamp, JobId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ImportJobSummary(
    jobId: Option[JobId] = None,
    importDestination: Option[zio.aws.sesv2.model.ImportDestination] = None,
    jobStatus: Option[zio.aws.sesv2.model.JobStatus] = None,
    createdTimestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ImportJobSummary = {
    import ImportJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ImportJobSummary
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(importDestination.map(value => value.buildAwsValue()))(
        _.importDestination
      )
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ImportJobSummary.ReadOnly =
    zio.aws.sesv2.model.ImportJobSummary.wrap(buildAwsValue())
}
object ImportJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ImportJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ImportJobSummary =
      zio.aws.sesv2.model.ImportJobSummary(
        jobId.map(value => value),
        importDestination.map(value => value.asEditable),
        jobStatus.map(value => value),
        createdTimestamp.map(value => value)
      )
    def jobId: Option[JobId]
    def importDestination
        : Option[zio.aws.sesv2.model.ImportDestination.ReadOnly]
    def jobStatus: Option[zio.aws.sesv2.model.JobStatus]
    def createdTimestamp: Option[Timestamp]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getImportDestination
        : ZIO[Any, AwsError, zio.aws.sesv2.model.ImportDestination.ReadOnly] =
      AwsError.unwrapOptionField("importDestination", importDestination)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.sesv2.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ImportJobSummary
  ) extends zio.aws.sesv2.model.ImportJobSummary.ReadOnly {
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.sesv2.model.primitives.JobId(value))
    override val importDestination
        : Option[zio.aws.sesv2.model.ImportDestination.ReadOnly] = scala
      .Option(impl.importDestination())
      .map(value => zio.aws.sesv2.model.ImportDestination.wrap(value))
    override val jobStatus: Option[zio.aws.sesv2.model.JobStatus] = scala
      .Option(impl.jobStatus())
      .map(value => zio.aws.sesv2.model.JobStatus.wrap(value))
    override val createdTimestamp: Option[Timestamp] = scala
      .Option(impl.createdTimestamp())
      .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ImportJobSummary
  ): zio.aws.sesv2.model.ImportJobSummary.ReadOnly = new Wrapper(impl)
}
