package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{
  ConfigurationSetName,
  Policy,
  PolicyName,
  Enabled
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetEmailIdentityResponse(
    identityType: Option[zio.aws.sesv2.model.IdentityType] = None,
    feedbackForwardingStatus: Option[Enabled] = None,
    verifiedForSendingStatus: Option[Enabled] = None,
    dkimAttributes: Option[zio.aws.sesv2.model.DkimAttributes] = None,
    mailFromAttributes: Option[zio.aws.sesv2.model.MailFromAttributes] = None,
    policies: Option[Map[PolicyName, Policy]] = None,
    tags: Option[Iterable[zio.aws.sesv2.model.Tag]] = None,
    configurationSetName: Option[ConfigurationSetName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetEmailIdentityResponse = {
    import GetEmailIdentityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetEmailIdentityResponse
      .builder()
      .optionallyWith(identityType.map(value => value.unwrap))(_.identityType)
      .optionallyWith(
        feedbackForwardingStatus.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.feedbackForwardingStatus)
      .optionallyWith(
        verifiedForSendingStatus.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.verifiedForSendingStatus)
      .optionallyWith(dkimAttributes.map(value => value.buildAwsValue()))(
        _.dkimAttributes
      )
      .optionallyWith(mailFromAttributes.map(value => value.buildAwsValue()))(
        _.mailFromAttributes
      )
      .optionallyWith(
        policies.map(value =>
          value
            .map({ case (key, value) =>
              (PolicyName.unwrap(key): java.lang.String) -> (Policy.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.policies)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        configurationSetName.map(value =>
          ConfigurationSetName.unwrap(value): java.lang.String
        )
      )(_.configurationSetName)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetEmailIdentityResponse.ReadOnly =
    zio.aws.sesv2.model.GetEmailIdentityResponse.wrap(buildAwsValue())
}
object GetEmailIdentityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetEmailIdentityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetEmailIdentityResponse =
      zio.aws.sesv2.model.GetEmailIdentityResponse(
        identityType.map(value => value),
        feedbackForwardingStatus.map(value => value),
        verifiedForSendingStatus.map(value => value),
        dkimAttributes.map(value => value.asEditable),
        mailFromAttributes.map(value => value.asEditable),
        policies.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configurationSetName.map(value => value)
      )
    def identityType: Option[zio.aws.sesv2.model.IdentityType]
    def feedbackForwardingStatus: Option[Enabled]
    def verifiedForSendingStatus: Option[Enabled]
    def dkimAttributes: Option[zio.aws.sesv2.model.DkimAttributes.ReadOnly]
    def mailFromAttributes
        : Option[zio.aws.sesv2.model.MailFromAttributes.ReadOnly]
    def policies: Option[Map[PolicyName, Policy]]
    def tags: Option[List[zio.aws.sesv2.model.Tag.ReadOnly]]
    def configurationSetName: Option[ConfigurationSetName]
    def getIdentityType: ZIO[Any, AwsError, zio.aws.sesv2.model.IdentityType] =
      AwsError.unwrapOptionField("identityType", identityType)
    def getFeedbackForwardingStatus: ZIO[Any, AwsError, Enabled] = AwsError
      .unwrapOptionField("feedbackForwardingStatus", feedbackForwardingStatus)
    def getVerifiedForSendingStatus: ZIO[Any, AwsError, Enabled] = AwsError
      .unwrapOptionField("verifiedForSendingStatus", verifiedForSendingStatus)
    def getDkimAttributes
        : ZIO[Any, AwsError, zio.aws.sesv2.model.DkimAttributes.ReadOnly] =
      AwsError.unwrapOptionField("dkimAttributes", dkimAttributes)
    def getMailFromAttributes
        : ZIO[Any, AwsError, zio.aws.sesv2.model.MailFromAttributes.ReadOnly] =
      AwsError.unwrapOptionField("mailFromAttributes", mailFromAttributes)
    def getPolicies: ZIO[Any, AwsError, Map[PolicyName, Policy]] =
      AwsError.unwrapOptionField("policies", policies)
    def getTags: ZIO[Any, AwsError, List[zio.aws.sesv2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getConfigurationSetName: ZIO[Any, AwsError, ConfigurationSetName] =
      AwsError.unwrapOptionField("configurationSetName", configurationSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetEmailIdentityResponse
  ) extends zio.aws.sesv2.model.GetEmailIdentityResponse.ReadOnly {
    override val identityType: Option[zio.aws.sesv2.model.IdentityType] = scala
      .Option(impl.identityType())
      .map(value => zio.aws.sesv2.model.IdentityType.wrap(value))
    override val feedbackForwardingStatus: Option[Enabled] = scala
      .Option(impl.feedbackForwardingStatus())
      .map(value => zio.aws.sesv2.model.primitives.Enabled(value))
    override val verifiedForSendingStatus: Option[Enabled] = scala
      .Option(impl.verifiedForSendingStatus())
      .map(value => zio.aws.sesv2.model.primitives.Enabled(value))
    override val dkimAttributes
        : Option[zio.aws.sesv2.model.DkimAttributes.ReadOnly] = scala
      .Option(impl.dkimAttributes())
      .map(value => zio.aws.sesv2.model.DkimAttributes.wrap(value))
    override val mailFromAttributes
        : Option[zio.aws.sesv2.model.MailFromAttributes.ReadOnly] = scala
      .Option(impl.mailFromAttributes())
      .map(value => zio.aws.sesv2.model.MailFromAttributes.wrap(value))
    override val policies: Option[Map[PolicyName, Policy]] = scala
      .Option(impl.policies())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sesv2.model.primitives
              .PolicyName(key) -> zio.aws.sesv2.model.primitives.Policy(value)
          })
          .toMap
      )
    override val tags: Option[List[zio.aws.sesv2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.Tag.wrap(item)
        }.toList
      )
    override val configurationSetName: Option[ConfigurationSetName] = scala
      .Option(impl.configurationSetName())
      .map(value => zio.aws.sesv2.model.primitives.ConfigurationSetName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetEmailIdentityResponse
  ): zio.aws.sesv2.model.GetEmailIdentityResponse.ReadOnly = new Wrapper(impl)
}
