package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDedicatedIpsResponse(
    dedicatedIps: Option[Iterable[zio.aws.sesv2.model.DedicatedIp]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse = {
    import GetDedicatedIpsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse
      .builder()
      .optionallyWith(
        dedicatedIps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dedicatedIps)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetDedicatedIpsResponse.ReadOnly =
    zio.aws.sesv2.model.GetDedicatedIpsResponse.wrap(buildAwsValue())
}
object GetDedicatedIpsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetDedicatedIpsResponse =
      zio.aws.sesv2.model.GetDedicatedIpsResponse(
        dedicatedIps.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def dedicatedIps: Option[List[zio.aws.sesv2.model.DedicatedIp.ReadOnly]]
    def nextToken: Option[NextToken]
    def getDedicatedIps
        : ZIO[Any, AwsError, List[zio.aws.sesv2.model.DedicatedIp.ReadOnly]] =
      AwsError.unwrapOptionField("dedicatedIps", dedicatedIps)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse
  ) extends zio.aws.sesv2.model.GetDedicatedIpsResponse.ReadOnly {
    override val dedicatedIps
        : Option[List[zio.aws.sesv2.model.DedicatedIp.ReadOnly]] = scala
      .Option(impl.dedicatedIps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.DedicatedIp.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse
  ): zio.aws.sesv2.model.GetDedicatedIpsResponse.ReadOnly = new Wrapper(impl)
}
