package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{
  EmailTemplateName,
  EmailAddress,
  EmailTemplateSubject,
  TemplateContent,
  FailureRedirectionURL,
  SuccessRedirectionURL
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetCustomVerificationEmailTemplateResponse(
    templateName: Option[EmailTemplateName] = None,
    fromEmailAddress: Option[EmailAddress] = None,
    templateSubject: Option[EmailTemplateSubject] = None,
    templateContent: Option[TemplateContent] = None,
    successRedirectionURL: Option[SuccessRedirectionURL] = None,
    failureRedirectionURL: Option[FailureRedirectionURL] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetCustomVerificationEmailTemplateResponse = {
    import GetCustomVerificationEmailTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetCustomVerificationEmailTemplateResponse
      .builder()
      .optionallyWith(
        templateName.map(value =>
          EmailTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        fromEmailAddress.map(value =>
          EmailAddress.unwrap(value): java.lang.String
        )
      )(_.fromEmailAddress)
      .optionallyWith(
        templateSubject.map(value =>
          EmailTemplateSubject.unwrap(value): java.lang.String
        )
      )(_.templateSubject)
      .optionallyWith(
        templateContent.map(value =>
          TemplateContent.unwrap(value): java.lang.String
        )
      )(_.templateContent)
      .optionallyWith(
        successRedirectionURL.map(value =>
          SuccessRedirectionURL.unwrap(value): java.lang.String
        )
      )(_.successRedirectionURL)
      .optionallyWith(
        failureRedirectionURL.map(value =>
          FailureRedirectionURL.unwrap(value): java.lang.String
        )
      )(_.failureRedirectionURL)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.GetCustomVerificationEmailTemplateResponse.ReadOnly =
    zio.aws.sesv2.model.GetCustomVerificationEmailTemplateResponse
      .wrap(buildAwsValue())
}
object GetCustomVerificationEmailTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetCustomVerificationEmailTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.GetCustomVerificationEmailTemplateResponse =
      zio.aws.sesv2.model.GetCustomVerificationEmailTemplateResponse(
        templateName.map(value => value),
        fromEmailAddress.map(value => value),
        templateSubject.map(value => value),
        templateContent.map(value => value),
        successRedirectionURL.map(value => value),
        failureRedirectionURL.map(value => value)
      )
    def templateName: Option[EmailTemplateName]
    def fromEmailAddress: Option[EmailAddress]
    def templateSubject: Option[EmailTemplateSubject]
    def templateContent: Option[TemplateContent]
    def successRedirectionURL: Option[SuccessRedirectionURL]
    def failureRedirectionURL: Option[FailureRedirectionURL]
    def getTemplateName: ZIO[Any, AwsError, EmailTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getFromEmailAddress: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField("fromEmailAddress", fromEmailAddress)
    def getTemplateSubject: ZIO[Any, AwsError, EmailTemplateSubject] =
      AwsError.unwrapOptionField("templateSubject", templateSubject)
    def getTemplateContent: ZIO[Any, AwsError, TemplateContent] =
      AwsError.unwrapOptionField("templateContent", templateContent)
    def getSuccessRedirectionURL: ZIO[Any, AwsError, SuccessRedirectionURL] =
      AwsError.unwrapOptionField("successRedirectionURL", successRedirectionURL)
    def getFailureRedirectionURL: ZIO[Any, AwsError, FailureRedirectionURL] =
      AwsError.unwrapOptionField("failureRedirectionURL", failureRedirectionURL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetCustomVerificationEmailTemplateResponse
  ) extends zio.aws.sesv2.model.GetCustomVerificationEmailTemplateResponse.ReadOnly {
    override val templateName: Option[EmailTemplateName] = scala
      .Option(impl.templateName())
      .map(value => zio.aws.sesv2.model.primitives.EmailTemplateName(value))
    override val fromEmailAddress: Option[EmailAddress] = scala
      .Option(impl.fromEmailAddress())
      .map(value => zio.aws.sesv2.model.primitives.EmailAddress(value))
    override val templateSubject: Option[EmailTemplateSubject] = scala
      .Option(impl.templateSubject())
      .map(value => zio.aws.sesv2.model.primitives.EmailTemplateSubject(value))
    override val templateContent: Option[TemplateContent] = scala
      .Option(impl.templateContent())
      .map(value => zio.aws.sesv2.model.primitives.TemplateContent(value))
    override val successRedirectionURL: Option[SuccessRedirectionURL] = scala
      .Option(impl.successRedirectionURL())
      .map(value => zio.aws.sesv2.model.primitives.SuccessRedirectionURL(value))
    override val failureRedirectionURL: Option[FailureRedirectionURL] = scala
      .Option(impl.failureRedirectionURL())
      .map(value => zio.aws.sesv2.model.primitives.FailureRedirectionURL(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetCustomVerificationEmailTemplateResponse
  ): zio.aws.sesv2.model.GetCustomVerificationEmailTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
