package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.PoolName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeliveryOptions(
    tlsPolicy: Option[zio.aws.sesv2.model.TlsPolicy] = None,
    sendingPoolName: Option[PoolName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.DeliveryOptions = {
    import DeliveryOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.DeliveryOptions
      .builder()
      .optionallyWith(tlsPolicy.map(value => value.unwrap))(_.tlsPolicy)
      .optionallyWith(
        sendingPoolName.map(value => PoolName.unwrap(value): java.lang.String)
      )(_.sendingPoolName)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.DeliveryOptions.ReadOnly =
    zio.aws.sesv2.model.DeliveryOptions.wrap(buildAwsValue())
}
object DeliveryOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.DeliveryOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.DeliveryOptions =
      zio.aws.sesv2.model.DeliveryOptions(
        tlsPolicy.map(value => value),
        sendingPoolName.map(value => value)
      )
    def tlsPolicy: Option[zio.aws.sesv2.model.TlsPolicy]
    def sendingPoolName: Option[PoolName]
    def getTlsPolicy: ZIO[Any, AwsError, zio.aws.sesv2.model.TlsPolicy] =
      AwsError.unwrapOptionField("tlsPolicy", tlsPolicy)
    def getSendingPoolName: ZIO[Any, AwsError, PoolName] =
      AwsError.unwrapOptionField("sendingPoolName", sendingPoolName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.DeliveryOptions
  ) extends zio.aws.sesv2.model.DeliveryOptions.ReadOnly {
    override val tlsPolicy: Option[zio.aws.sesv2.model.TlsPolicy] = scala
      .Option(impl.tlsPolicy())
      .map(value => zio.aws.sesv2.model.TlsPolicy.wrap(value))
    override val sendingPoolName: Option[PoolName] = scala
      .Option(impl.sendingPoolName())
      .map(value => zio.aws.sesv2.model.primitives.PoolName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.DeliveryOptions
  ): zio.aws.sesv2.model.DeliveryOptions.ReadOnly = new Wrapper(impl)
}
