package zio.aws.sesv2.model
import java.lang.Integer
import zio.aws.sesv2.model.primitives.{PoolName, Percentage100Wrapper, Ip}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DedicatedIp(
    ip: Ip,
    warmupStatus: zio.aws.sesv2.model.WarmupStatus,
    warmupPercentage: Percentage100Wrapper,
    poolName: Option[PoolName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.DedicatedIp = {
    import DedicatedIp.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.DedicatedIp
      .builder()
      .ip(Ip.unwrap(ip): java.lang.String)
      .warmupStatus(warmupStatus.unwrap)
      .warmupPercentage(Percentage100Wrapper.unwrap(warmupPercentage): Integer)
      .optionallyWith(
        poolName.map(value => PoolName.unwrap(value): java.lang.String)
      )(_.poolName)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.DedicatedIp.ReadOnly =
    zio.aws.sesv2.model.DedicatedIp.wrap(buildAwsValue())
}
object DedicatedIp {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sesv2.model.DedicatedIp] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.DedicatedIp =
      zio.aws.sesv2.model.DedicatedIp(
        ip,
        warmupStatus,
        warmupPercentage,
        poolName.map(value => value)
      )
    def ip: Ip
    def warmupStatus: zio.aws.sesv2.model.WarmupStatus
    def warmupPercentage: Percentage100Wrapper
    def poolName: Option[PoolName]
    def getIp: ZIO[Any, Nothing, Ip] = ZIO.succeed(ip)
    def getWarmupStatus: ZIO[Any, Nothing, zio.aws.sesv2.model.WarmupStatus] =
      ZIO.succeed(warmupStatus)
    def getWarmupPercentage: ZIO[Any, Nothing, Percentage100Wrapper] =
      ZIO.succeed(warmupPercentage)
    def getPoolName: ZIO[Any, AwsError, PoolName] =
      AwsError.unwrapOptionField("poolName", poolName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.DedicatedIp
  ) extends zio.aws.sesv2.model.DedicatedIp.ReadOnly {
    override val ip: Ip = zio.aws.sesv2.model.primitives.Ip(impl.ip())
    override val warmupStatus: zio.aws.sesv2.model.WarmupStatus =
      zio.aws.sesv2.model.WarmupStatus.wrap(impl.warmupStatus())
    override val warmupPercentage: Percentage100Wrapper =
      zio.aws.sesv2.model.primitives
        .Percentage100Wrapper(impl.warmupPercentage())
    override val poolName: Option[PoolName] = scala
      .Option(impl.poolName())
      .map(value => zio.aws.sesv2.model.primitives.PoolName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.DedicatedIp
  ): zio.aws.sesv2.model.DedicatedIp.ReadOnly = new Wrapper(impl)
}
