package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DailyVolume(
    startDate: Option[Timestamp] = None,
    volumeStatistics: Option[zio.aws.sesv2.model.VolumeStatistics] = None,
    domainIspPlacements: Option[
      Iterable[zio.aws.sesv2.model.DomainIspPlacement]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.DailyVolume = {
    import DailyVolume.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.DailyVolume
      .builder()
      .optionallyWith(startDate.map(value => Timestamp.unwrap(value): Instant))(
        _.startDate
      )
      .optionallyWith(volumeStatistics.map(value => value.buildAwsValue()))(
        _.volumeStatistics
      )
      .optionallyWith(
        domainIspPlacements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainIspPlacements)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.DailyVolume.ReadOnly =
    zio.aws.sesv2.model.DailyVolume.wrap(buildAwsValue())
}
object DailyVolume {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sesv2.model.DailyVolume] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.DailyVolume =
      zio.aws.sesv2.model.DailyVolume(
        startDate.map(value => value),
        volumeStatistics.map(value => value.asEditable),
        domainIspPlacements.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def startDate: Option[Timestamp]
    def volumeStatistics: Option[zio.aws.sesv2.model.VolumeStatistics.ReadOnly]
    def domainIspPlacements
        : Option[List[zio.aws.sesv2.model.DomainIspPlacement.ReadOnly]]
    def getStartDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getVolumeStatistics
        : ZIO[Any, AwsError, zio.aws.sesv2.model.VolumeStatistics.ReadOnly] =
      AwsError.unwrapOptionField("volumeStatistics", volumeStatistics)
    def getDomainIspPlacements: ZIO[Any, AwsError, List[
      zio.aws.sesv2.model.DomainIspPlacement.ReadOnly
    ]] = AwsError.unwrapOptionField("domainIspPlacements", domainIspPlacements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.DailyVolume
  ) extends zio.aws.sesv2.model.DailyVolume.ReadOnly {
    override val startDate: Option[Timestamp] = scala
      .Option(impl.startDate())
      .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
    override val volumeStatistics
        : Option[zio.aws.sesv2.model.VolumeStatistics.ReadOnly] = scala
      .Option(impl.volumeStatistics())
      .map(value => zio.aws.sesv2.model.VolumeStatistics.wrap(value))
    override val domainIspPlacements
        : Option[List[zio.aws.sesv2.model.DomainIspPlacement.ReadOnly]] = scala
      .Option(impl.domainIspPlacements())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.DomainIspPlacement.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.DailyVolume
  ): zio.aws.sesv2.model.DailyVolume.ReadOnly = new Wrapper(impl)
}
