package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{Description, ContactListName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateContactListRequest(
    contactListName: ContactListName,
    topics: Option[Iterable[zio.aws.sesv2.model.Topic]] = None,
    description: Option[Description] = None,
    tags: Option[Iterable[zio.aws.sesv2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.CreateContactListRequest = {
    import CreateContactListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.CreateContactListRequest
      .builder()
      .contactListName(
        ContactListName.unwrap(contactListName): java.lang.String
      )
      .optionallyWith(
        topics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.topics)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.CreateContactListRequest.ReadOnly =
    zio.aws.sesv2.model.CreateContactListRequest.wrap(buildAwsValue())
}
object CreateContactListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.CreateContactListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.CreateContactListRequest =
      zio.aws.sesv2.model.CreateContactListRequest(
        contactListName,
        topics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def contactListName: ContactListName
    def topics: Option[List[zio.aws.sesv2.model.Topic.ReadOnly]]
    def description: Option[Description]
    def tags: Option[List[zio.aws.sesv2.model.Tag.ReadOnly]]
    def getContactListName: ZIO[Any, Nothing, ContactListName] =
      ZIO.succeed(contactListName)
    def getTopics
        : ZIO[Any, AwsError, List[zio.aws.sesv2.model.Topic.ReadOnly]] =
      AwsError.unwrapOptionField("topics", topics)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.sesv2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.CreateContactListRequest
  ) extends zio.aws.sesv2.model.CreateContactListRequest.ReadOnly {
    override val contactListName: ContactListName =
      zio.aws.sesv2.model.primitives.ContactListName(impl.contactListName())
    override val topics: Option[List[zio.aws.sesv2.model.Topic.ReadOnly]] =
      scala
        .Option(impl.topics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.Topic.wrap(item)
          }.toList
        )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.sesv2.model.primitives.Description(value))
    override val tags: Option[List[zio.aws.sesv2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.CreateContactListRequest
  ): zio.aws.sesv2.model.CreateContactListRequest.ReadOnly = new Wrapper(impl)
}
