package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.ContactListName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ContactListDestination(
    contactListName: ContactListName,
    contactListImportAction: zio.aws.sesv2.model.ContactListImportAction
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ContactListDestination = {
    import ContactListDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ContactListDestination
      .builder()
      .contactListName(
        ContactListName.unwrap(contactListName): java.lang.String
      )
      .contactListImportAction(contactListImportAction.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ContactListDestination.ReadOnly =
    zio.aws.sesv2.model.ContactListDestination.wrap(buildAwsValue())
}
object ContactListDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ContactListDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ContactListDestination =
      zio.aws.sesv2.model
        .ContactListDestination(contactListName, contactListImportAction)
    def contactListName: ContactListName
    def contactListImportAction: zio.aws.sesv2.model.ContactListImportAction
    def getContactListName: ZIO[Any, Nothing, ContactListName] =
      ZIO.succeed(contactListName)
    def getContactListImportAction
        : ZIO[Any, Nothing, zio.aws.sesv2.model.ContactListImportAction] =
      ZIO.succeed(contactListImportAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ContactListDestination
  ) extends zio.aws.sesv2.model.ContactListDestination.ReadOnly {
    override val contactListName: ContactListName =
      zio.aws.sesv2.model.primitives.ContactListName(impl.contactListName())
    override val contactListImportAction
        : zio.aws.sesv2.model.ContactListImportAction =
      zio.aws.sesv2.model.ContactListImportAction
        .wrap(impl.contactListImportAction())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ContactListDestination
  ): zio.aws.sesv2.model.ContactListDestination.ReadOnly = new Wrapper(impl)
}
